/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class ToolBarLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private int axis;

    public ToolBarLayout() {
        this(0);
    }

    public ToolBarLayout(int axis) {
        this.axis = axis;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        switch (this.axis) {
            case 1: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        switch (this.axis) {
            case 1: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int w = 0;
        int h = 0;
        switch (this.axis) {
            case 1: {
                for (Component c : parent.getComponents()) {
                    Dimension ps = c.getPreferredSize();
                    w = Math.max(w, ps.width);
                    h += ps.height;
                }
                break;
            }
            default: {
                for (Component c : parent.getComponents()) {
                    Dimension ps = c.getPreferredSize();
                    h = Math.max(h, ps.height);
                    w += ps.width;
                }
            }
        }
        Insets i = parent.getInsets();
        return new Dimension(w + i.left + i.right, h + i.top + i.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension ps = this.preferredLayoutSize(parent);
        Insets insets = parent.getInsets();
        int w = ps.width - insets.left - insets.right;
        int h = ps.height - insets.top - insets.bottom;
        int x = insets.left;
        int y = insets.top;
        switch (this.axis) {
            case 1: {
                for (Component c : parent.getComponents()) {
                    ps = c.getPreferredSize();
                    c.setBounds(x, y, w, ps.height);
                    y += ps.height;
                }
                break;
            }
            default: {
                for (Component c : parent.getComponents()) {
                    ps = c.getPreferredSize();
                    c.setBounds(x, y, ps.width, h);
                    x += ps.width;
                }
            }
        }
    }
}

