/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FloatingTextField;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextEditingTool
extends AbstractTool
implements ActionListener {
    private FloatingTextField textField;
    private TextHolderFigure typingTarget;

    public TextEditingTool(TextHolderFigure typingTarget) {
        this.typingTarget = typingTarget;
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        this.endEdit();
        super.deactivate(editor);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.typingTarget != null) {
            this.beginEdit(this.typingTarget);
            this.updateCursor(this.getView(), e.getPoint());
        }
    }

    protected void beginEdit(TextHolderFigure textHolder) {
        if (this.textField == null) {
            this.textField = new FloatingTextField();
            this.textField.addActionListener(this);
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textField.createOverlay(this.getView(), textHolder);
        this.textField.requestFocus();
        this.typingTarget = textHolder;
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            this.typingTarget.willChange();
            final TextHolderFigure editedFigure = this.typingTarget;
            final String oldText = this.typingTarget.getText();
            final String newText = this.textField.getText();
            if (newText.length() > 0) {
                this.typingTarget.setText(newText);
            }
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return labels.getString("attribute.text.text");
                }

                @Override
                public void undo() {
                    super.undo();
                    editedFigure.willChange();
                    editedFigure.setText(oldText);
                    editedFigure.changed();
                }

                @Override
                public void redo() {
                    super.redo();
                    editedFigure.willChange();
                    editedFigure.setText(newText);
                    editedFigure.changed();
                }
            };
            this.getDrawing().fireUndoableEditHappened(edit);
            this.typingTarget.changed();
            this.typingTarget = null;
            this.textField.endOverlay();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.fireToolDone();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.endEdit();
        this.fireToolDone();
    }

    public boolean isEditing() {
        return this.typingTarget != null;
    }

    @Override
    public void updateCursor(DrawingView view, Point p) {
        if (view.isEnabled()) {
            view.setCursor(Cursor.getPredefinedCursor(this.isEditing() ? 0 : 1));
        } else {
            view.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

