/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class CompositeLineDecoration
implements LineDecoration,
DOMStorable {
    private List<LineDecoration> decorations = new ArrayList<LineDecoration>();

    public CompositeLineDecoration() {
    }

    public CompositeLineDecoration(LineDecoration decoration1, LineDecoration decoration2) {
        this.addDecoration(decoration1);
        this.addDecoration(decoration2);
    }

    public void addDecoration(LineDecoration decoration) {
        if (decoration != null) {
            this.decorations.add(decoration);
        }
    }

    @Override
    public void draw(Graphics2D g, Figure f, Point2D.Double p1, Point2D.Double p2) {
        for (LineDecoration decoration : this.decorations) {
            decoration.draw(g, f, p1, p2);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea(Figure f, Point2D.Double p1, Point2D.Double p2) {
        Rectangle2D.Double r = null;
        for (LineDecoration decoration : this.decorations) {
            Rectangle2D.Double aR = decoration.getDrawingArea(f, p1, p2);
            if (r == null) {
                r = aR;
                continue;
            }
            r.add(aR);
        }
        return r;
    }

    @Override
    public double getDecorationRadius(Figure f) {
        double radius = 0.0;
        for (LineDecoration decoration : this.decorations) {
            radius = Math.max(radius, decoration.getDecorationRadius(f));
        }
        return radius;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        for (int i = in.getElementCount("decoration") - 1; i >= 0; --i) {
            in.openElement("decoration", i);
            Object value = in.readObject();
            if (value instanceof LineDecoration) {
                this.addDecoration((LineDecoration)value);
            }
            in.closeElement();
        }
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        for (LineDecoration decoration : this.decorations) {
            out.openElement("decoration");
            out.writeObject(decoration);
            out.closeElement();
        }
    }
}

