/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import org.jhotdraw.color.AbstractColorSystem;

public class CMYKNominalColorSystem
extends AbstractColorSystem {
    @Override
    public float[] toComponents(int r, int g, int b, float[] component) {
        float black;
        if (component == null || component.length != 4) {
            component = new float[4];
        }
        float cyan = 1.0f - (float)r / 255.0f;
        float magenta = 1.0f - (float)g / 255.0f;
        float yellow = 1.0f - (float)b / 255.0f;
        if (Math.min(Math.min(cyan, magenta), yellow) >= 1.0f) {
            yellow = 0.0f;
            magenta = 0.0f;
            cyan = 0.0f;
            black = 1.0f;
        } else {
            black = Math.min(Math.min(cyan, magenta), yellow);
            if (black > 0.0f) {
                cyan = (cyan - black) / (1.0f - black);
                magenta = (magenta - black) / (1.0f - black);
                yellow = (yellow - black) / (1.0f - black);
            }
        }
        component[0] = cyan;
        component[1] = magenta;
        component[2] = yellow;
        component[3] = black;
        return component;
    }

    @Override
    public int toRGB(float ... component) {
        float cyan = component[0];
        float magenta = component[1];
        float yellow = component[2];
        float black = component[3];
        float red = 1.0f - cyan * (1.0f - black) - black;
        float green = 1.0f - magenta * (1.0f - black) - black;
        float blue = 1.0f - yellow * (1.0f - black) - black;
        return 0xFF000000 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    @Override
    public int getComponentCount() {
        return 4;
    }
}

