/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading;

import java.util.Map;
import javafx.concurrent.Task;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.trading.api.Order;
import org.yccheok.jstock.trading.api.OrderManager;

public class BuySell {
    private static final Log log = LogFactory.getLog(BuySell.class);

    private BuySell() {
    }

    public static Task startThread(OrderManager.OrderSide orderSide, OrderManager.OrderType orderType, Map<String, Object> params) {
        log.info((Object)("Start " + orderSide.value + " order thread ...."));
        Task task = BuySell.getTask(orderSide, orderType, params);
        Thread thread = new Thread((Runnable)task);
        thread.start();
        return task;
    }

    private static Task getTask(final OrderManager.OrderSide orderSide, final OrderManager.OrderType orderType, final Map<String, Object> params) {
        Task<Pair<Order, String>> buySellTask = new Task<Pair<Order, String>>(){

            protected Pair<Order, String> call() {
                log.info((Object)"BuySellTask call Create Order");
                Pair<Order, String> createPair = OrderManager.createOrder(orderSide, orderType, params);
                Order createOrder = (Order)createPair.first;
                String createError = (String)createPair.second;
                if (createError != null) {
                    log.error((Object)("BuySellTask call Create Order DONE, Error: " + createError));
                    return new Pair<Object, String>(null, createError);
                }
                log.info((Object)("BuySellTask call Order Status - orderID: " + createOrder.orderID + ", statusPath: " + createOrder.statusPath));
                Order statusOrder = null;
                String statusError = null;
                for (int count = 0; count < 5; ++count) {
                    log.info((Object)("BuySellTask Order Status Loop: " + count));
                    Pair<Order, String> statusPair = OrderManager.orderStatus(createOrder.orderID);
                    statusOrder = (Order)statusPair.first;
                    statusError = (String)statusPair.second;
                    if (statusError == null || !statusError.startsWith("404 ")) break;
                    log.warn((Object)("BuySellTask Order Status Error [404 NOT FOUND] - " + statusError + ", Sleep & Retry Order Status"));
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
                if (statusError != null) {
                    statusError = statusError.replaceFirst("404 ", "");
                    log.error((Object)("BuySellTask call Order Status DONE, Error: " + statusError));
                    return new Pair<Object, String>(null, statusError);
                }
                if (statusOrder != null && statusOrder.ordStatusEnum != null) {
                    log.info((Object)("BuySellTask get order status DONE, order status: " + statusOrder.ordStatusEnum.value));
                }
                return new Pair<Object, Object>(statusOrder, null);
            }
        };
        return buySellTask;
    }
}

