/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.trading.AccountSummaryHeader;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.gui.trading.TradingView;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.Account;
import org.yccheok.jstock.trading.api.SessionManager;
import org.yccheok.jstock.trading.api.User;

public class AccountMenu {
    private ComboBox<Object> accCombo;
    private static final AccountMenu INSTANCE = new AccountMenu();
    private static final Log log = LogFactory.getLog(AccountMenu.class);

    private AccountMenu() {
    }

    public static AccountMenu getInstance() {
        return INSTANCE;
    }

    public ComboBox<Object> show() {
        this.initUI();
        return this.accCombo;
    }

    private void initUI() {
        this.accCombo = new ComboBox();
        User user = SessionManager.getInstance().getUser();
        ObservableList options = FXCollections.observableArrayList(user.getAccounts());
        this.accCombo.setItems(options);
        String profile = DriveWealthBundle.getString("Profile");
        String reports = DriveWealthBundle.getString("Menu_Reports");
        String help = DriveWealthBundle.getString("Menu_Help");
        String logout = DriveWealthBundle.getString("Menu_Logout");
        options.add((Object)profile);
        options.add((Object)reports);
        options.add((Object)help);
        options.add((Object)logout);
        this.accCombo.setCellFactory((Callback)new Callback<ListView<Object>, ListCell<Object>>(){

            public ListCell<Object> call(ListView<Object> p) {
                ListCell<Object> cell = new ListCell<Object>(){

                    protected void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        if (empty || item == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else if (item instanceof Account) {
                            Account ac = (Account)item;
                            String acTypeName = ac.accType == SessionManager.AccType.LIVE ? DriveWealthBundle.getString("Live_account") : DriveWealthBundle.getString("Practice_account");
                            Label acType = new Label(acTypeName);
                            acType.getStyleClass().addAll((Object[])new String[]{"small-font", "underline"});
                            Label acNo = new Label(ac.accountNo);
                            acNo.getStyleClass().add((Object)"big-font");
                            VBox accBox = new VBox();
                            accBox.setSpacing(5.0);
                            accBox.getChildren().addAll((Object[])new Node[]{acType, acNo});
                            this.setGraphic((Node)accBox);
                        } else {
                            VBox vBox = new VBox();
                            vBox.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
                            Label itemLabel = new Label((String)item);
                            vBox.getChildren().add((Object)itemLabel);
                            this.setGraphic((Node)vBox);
                        }
                    }
                };
                return cell;
            }
        });
        Account active = user.getActiveAccount();
        if (active != null) {
            this.accCombo.getSelectionModel().select((Object)active);
        }
        this.accCombo.getSelectionModel().selectedItemProperty().addListener((arg0, oldVal, newVal) -> {
            if (newVal != null) {
                if (newVal instanceof Account) {
                    if (oldVal instanceof String) {
                        return;
                    }
                    this.switchAcc((Account)newVal);
                    return;
                }
                if (newVal instanceof String) {
                    String action = (String)newVal;
                    if (action.equals(logout)) {
                        TradingView.getInstance().showProgIndicator();
                        Task<Boolean> task = new Task<Boolean>(){

                            protected Boolean call() throws Exception {
                                return SessionManager.cancelSession();
                            }
                        };
                        Thread thread = new Thread((Runnable)task);
                        thread.start();
                        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                            public void handle(WorkerStateEvent workerStateEvent) {
                                Boolean result = (Boolean)workerStateEvent.getSource().getValue();
                                Portfolio.getInstance().stopAll();
                                TradingView.getInstance().showLogin();
                            }
                        });
                        return;
                    }
                    if (action.equals(profile)) {
                        Portfolio.getInstance().removeReportIfShowing();
                        Portfolio.getInstance().showProfile();
                    } else if (action.equals(reports)) {
                        Portfolio.getInstance().removeProfileIfShowing();
                        Portfolio.getInstance().showReport();
                    } else if (action.equals(help)) {
                        GUIUtils.openURLInBrowser("http://help.drivewealth.com/");
                    }
                    this.manualSelectAcc(user.getActiveAccount());
                }
            }
        });
    }

    private void switchAcc(Account active) {
        Portfolio.getInstance().removeReportIfShowing();
        Portfolio.getInstance().removeProfileIfShowing();
        Portfolio.getInstance().removeAccStatusIfExist();
        SessionManager.getInstance().getUser().setActiveAccount(active);
        AccountSummaryHeader.getInstance().updateActiveAccLabel();
        AccountSummaryHeader.getInstance().showHideFundBtn();
        AccountSummaryHeader.getInstance().showHideOpenLiveAccBtn();
        Portfolio.getInstance().resetTablesModel();
        Portfolio.getInstance().showAccStatusIfIncomplete();
    }

    public void manualSelectAcc(final Account active) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AccountMenu.this.accCombo.getItems().contains((Object)active)) {
                    AccountMenu.this.accCombo.setValue((Object)active);
                }
            }
        });
    }
}

