/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.alert.GoogleMail;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JStockOptionsObserver;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;

public class OptionsAlertJPanel
extends JPanel
implements JStockOptionsObserver {
    private Pair<Credential, String> credentialEx;
    private volatile SwingWorker testEmailSwingWorker = null;
    private static final Log log = LogFactory.getLog(OptionsAlertJPanel.class);
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox4;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JTextField jTextField1;
    private JXHeader jXHeader1;

    public OptionsAlertJPanel() {
        this.initComponents();
        this.initCredentialEx();
    }

    private void signOut() {
        this.credentialEx = null;
        this.jCheckBox2.setSelected(false);
        JStock.instance().getJStockOptions().setSendEmail(this.jCheckBox2.isSelected());
        this.jTextField1.setText("");
        org.yccheok.jstock.google.Utils.logoutGmail();
        this.updateGUIState();
    }

    private void signIn() {
        this.jCheckBox2.setEnabled(false);
        SwingWorker<Pair<Pair<Credential, String>, Boolean>, Void> swingWorker = new SwingWorker<Pair<Pair<Credential, String>, Boolean>, Void>(){

            @Override
            protected Pair<Pair<Credential, String>, Boolean> doInBackground() throws Exception {
                Pair<Pair<Credential, String>, Boolean> pair = org.yccheok.jstock.google.Utils.authorizeGmail();
                return pair;
            }

            @Override
            public void done() {
                Pair pair = null;
                try {
                    pair = (Pair)this.get();
                }
                catch (InterruptedException ex) {
                    JOptionPane.showMessageDialog(OptionsAlertJPanel.this, ex.getMessage(), GUIBundle.getString("OptionsAlertJPanel_Alert"), 0);
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Throwable throwable = ex.getCause();
                    if (throwable instanceof GoogleJsonResponseException) {
                        GoogleJsonResponseException ge = (GoogleJsonResponseException)throwable;
                        for (GoogleJsonError.ErrorInfo errorInfo : ge.getDetails().getErrors()) {
                            if (!"insufficientPermissions".equals(errorInfo.getReason())) continue;
                            org.yccheok.jstock.google.Utils.logoutGmail();
                            break;
                        }
                    }
                    JOptionPane.showMessageDialog(OptionsAlertJPanel.this, ex.getMessage(), GUIBundle.getString("OptionsAlertJPanel_Alert"), 0);
                    log.error(null, (Throwable)ex);
                }
                if (pair != null) {
                    OptionsAlertJPanel.this.credentialEx = (Pair)pair.first;
                } else {
                    OptionsAlertJPanel.this.jCheckBox2.setSelected(false);
                    JStock.instance().getJStockOptions().setSendEmail(OptionsAlertJPanel.this.jCheckBox2.isSelected());
                }
                OptionsAlertJPanel.this.updateGUIState();
            }
        };
        swingWorker.execute();
    }

    private void initCredentialEx() {
        SwingWorker<Pair<Credential, String>, Void> swingWorker = new SwingWorker<Pair<Credential, String>, Void>(){

            @Override
            protected Pair<Credential, String> doInBackground() throws Exception {
                Pair<Credential, String> pair = org.yccheok.jstock.google.Utils.authorizeGmailOffline();
                return pair;
            }

            @Override
            public void done() {
                Pair pair = null;
                try {
                    pair = (Pair)this.get();
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Throwable throwable = ex.getCause();
                    if (throwable instanceof GoogleJsonResponseException) {
                        GoogleJsonResponseException ge = (GoogleJsonResponseException)throwable;
                        for (GoogleJsonError.ErrorInfo errorInfo : ge.getDetails().getErrors()) {
                            if (!"insufficientPermissions".equals(errorInfo.getReason())) continue;
                            org.yccheok.jstock.google.Utils.logoutGmail();
                            break;
                        }
                    }
                    log.error(null, (Throwable)ex);
                }
                if (pair != null) {
                    OptionsAlertJPanel.this.credentialEx = pair;
                    OptionsAlertJPanel.this.jCheckBox2.setSelected(JStock.instance().getJStockOptions().isSendEmail());
                }
                OptionsAlertJPanel.this.updateGUIState();
            }
        };
        swingWorker.execute();
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jCheckBox2 = new JCheckBox();
        this.jButton1 = new JButton();
        this.jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel12 = new JLabel();
        this.jPanel2 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jLabel1 = new JLabel();
        this.filler3 = new Box.Filler(new Dimension(24, 0), new Dimension(24, 0), new Dimension(24, Short.MAX_VALUE));
        this.jButton2 = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPanel5 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jButton3 = new JButton();
        this.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("OptionsAlertJPanel_description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/bell.png")));
        this.jXHeader1.setTitle(bundle.getString("OptionsAlertJPanel_Alert"));
        this.add((Component)this.jXHeader1, "North");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsAlertJPanel_Email")));
        this.jCheckBox2.setText(bundle.getString("OptionsAlertJPanel_SendMessageToEmails"));
        this.jCheckBox2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsAlertJPanel.this.jCheckBox2ItemStateChanged(evt);
            }
        });
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/mail_send.png")));
        this.jButton1.setText(bundle.getString("OptionsAlertJPanel_TestEmail"));
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jLabel11.setText(bundle.getString("OptionsAlertJPanel_CCCopy"));
        this.jLabel11.setEnabled(false);
        this.jTextField1.setEnabled(false);
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jLabel12.setFont(this.jLabel12.getFont().deriveFont((float)this.jLabel12.getFont().getSize() - 1.0f));
        this.jLabel12.setText(bundle.getString("OptionsAlertJPanel_EmailExample"));
        this.jLabel12.setEnabled(false);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsAlertJPanel_GmalAccount")));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jPanel2.add(this.filler1);
        this.jLabel1.setBackground(new Color(140, 196, 116));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 1));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("username@email.com");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jLabel1.setOpaque(true);
        this.jPanel2.add(this.jLabel1);
        this.jPanel2.add(this.filler3);
        this.jButton2.setText(bundle.getString("OptionsAlertJPanel_SignOut"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton2);
        this.jPanel2.add(this.filler2);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextField1, -2, 183, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel12))).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1).addComponent(this.jLabel7)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsAlertJPanel_System")));
        this.jCheckBox1.setText(bundle.getString("OptionsAlertJPanel_ShowAMessage"));
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox4.setText(bundle.getString("OptionsAlertJPanel_PlayingAlertSound"));
        this.jCheckBox4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox4.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsAlertJPanel.this.jCheckBox4ItemStateChanged(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/sound.png")));
        this.jButton3.setText(bundle.getString("OptionsAlertJPanel_TestSound"));
        this.jButton3.setEnabled(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)).addComponent(this.jCheckBox1)).addGap(134, 134, 134)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1).addGap(16, 16, 16).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox4).addComponent(this.jButton3)).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Center");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.testEmailSwingWorker = this.getTestEmailSwingWorker();
        this.updateGUIState();
        this.jButton1.requestFocus();
        this.testEmailSwingWorker.execute();
    }

    private void jCheckBox2ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
        if (this.jCheckBox2.isSelected() && this.credentialEx == null) {
            this.signIn();
        }
    }

    private void jCheckBox4ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        Utils.playAlertSound();
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.jButton1.doClick();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.signOut();
    }

    public void cancel() {
        if (this.testEmailSwingWorker != null) {
            this.testEmailSwingWorker.cancel(true);
        }
    }

    @Override
    public void set(JStockOptions jStockOptions) {
        this.jCheckBox1.setSelected(jStockOptions.isPopupMessage());
        this.jCheckBox2.setSelected(jStockOptions.isSendEmail());
        this.jCheckBox4.setSelected(jStockOptions.isSoundEnabled());
        this.jTextField1.setText(Utils.decrypt(jStockOptions.getCCEmail()));
        this.updateGUIState();
    }

    @Override
    public boolean apply(JStockOptions jStockOptions) {
        if (this.jCheckBox2.isSelected()) {
            // empty if block
        }
        jStockOptions.setSoundEnabled(this.jCheckBox4.isSelected());
        jStockOptions.setPopupMessage(this.jCheckBox1.isSelected());
        jStockOptions.setSendEmail(this.jCheckBox2.isSelected());
        jStockOptions.setCCEmail(Utils.encrypt(this.jTextField1.getText().trim()));
        return true;
    }

    private void updateGUIState() {
        boolean isTestEmailDone = this.testEmailSwingWorker == null || this.testEmailSwingWorker.isDone();
        boolean soundState = this.jCheckBox4.isSelected();
        boolean emailState = this.jCheckBox2.isSelected();
        this.jButton3.setEnabled(soundState);
        this.jButton1.setEnabled(emailState && isTestEmailDone && this.credentialEx != null);
        this.jButton2.setEnabled(emailState && isTestEmailDone && this.credentialEx != null);
        this.jCheckBox2.setEnabled(isTestEmailDone);
        this.jLabel7.setVisible(!isTestEmailDone);
        this.jLabel11.setEnabled(emailState && this.credentialEx != null);
        this.jLabel12.setEnabled(emailState && this.credentialEx != null);
        this.jTextField1.setEnabled(emailState && isTestEmailDone && this.credentialEx != null);
        if (this.credentialEx == null) {
            this.jLabel1.setText("?");
        } else {
            this.jLabel1.setText((String)this.credentialEx.second);
        }
    }

    private SwingWorker getTestEmailSwingWorker() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            public Boolean doInBackground() {
                boolean status = true;
                Pair credentialEx = OptionsAlertJPanel.this.credentialEx;
                if (credentialEx == null) {
                    status = false;
                } else {
                    String ccEmail = OptionsAlertJPanel.this.jTextField1.getText().trim();
                    String title = MessagesBundle.getString("info_message_congratulation_email_alert_system_is_working");
                    String message = MessagesBundle.getString("info_message_congratulation_email_alert_system_is_working");
                    try {
                        GoogleMail.Send(ccEmail, title, message);
                    }
                    catch (Exception ex) {
                        log.error(null, (Throwable)ex);
                        status = false;
                    }
                }
                return status;
            }

            @Override
            public void done() {
                if (this.isCancelled()) {
                    return;
                }
                Boolean status = null;
                try {
                    status = (Boolean)this.get();
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (CancellationException ex) {
                    log.error(null, (Throwable)ex);
                }
                OptionsAlertJPanel.this.updateGUIState();
                if (status == null || !status.booleanValue()) {
                    JOptionPane.showMessageDialog(OptionsAlertJPanel.this, MessagesBundle.getString("error_message_error_in_sending_email"), MessagesBundle.getString("error_title_error_in_sending_email"), 0);
                } else {
                    JOptionPane.showMessageDialog(OptionsAlertJPanel.this, MessagesBundle.getString("info_message_email_alert_system_is_working"), MessagesBundle.getString("info_title_email_alert_system_is_working"), 1);
                }
            }
        };
        return worker;
    }
}

