/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.FontSizeNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;

public class FontSizeAction
extends NodeGeneralAction
implements NodeActorXml {
    private String actionSize;

    public FontSizeAction(MindMapController modeController) {
        super(modeController, "font_size", null, (NodeActorXml)null);
        this.addActor(this);
        this.actionSize = modeController.getFrame().getProperty("defaultfontsize");
    }

    public void actionPerformed(String size) {
        this.actionSize = size;
        super.actionPerformed(null);
    }

    @Override
    public ActionPair apply(MindMap model, MindMapNode selected) {
        return this.getActionPair(selected, this.actionSize);
    }

    @Override
    public Class getDoActionClass() {
        return FontSizeNodeAction.class;
    }

    public void setFontSize(MindMapNode node, String fontSizeValue) {
        if (Tools.safeEquals(fontSizeValue, node.getFontSize())) {
            return;
        }
        this.modeController.doTransaction((String)this.getValue("Name"), this.getActionPair(node, fontSizeValue));
    }

    private ActionPair getActionPair(MindMapNode node, String fontSizeValue) {
        FontSizeNodeAction fontSizeAction = this.createFontSizeNodeAction(node, fontSizeValue);
        FontSizeNodeAction undoFontSizeAction = this.createFontSizeNodeAction(node, node.getFontSize());
        return new ActionPair((XmlAction)fontSizeAction, (XmlAction)undoFontSizeAction);
    }

    private FontSizeNodeAction createFontSizeNodeAction(MindMapNode node, String fontSizeValue) {
        FontSizeNodeAction fontSizeAction = new FontSizeNodeAction();
        fontSizeAction.setNode(this.getNodeID(node));
        fontSizeAction.setSize(fontSizeValue);
        return fontSizeAction;
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof FontSizeNodeAction) {
            FontSizeNodeAction fontSizeAction = (FontSizeNodeAction)action;
            NodeAdapter node = this.getNodeFromID(fontSizeAction.getNode());
            try {
                int size = Integer.valueOf(fontSizeAction.getSize());
                if (!node.getFontSize().equals(fontSizeAction.getSize())) {
                    node.setFontSize(size);
                    this.modeController.nodeChanged(node);
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }
}

