/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import org.python.core.PathPackageManager;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PySystemState;

public class SysPackageManager
extends PathPackageManager {
    protected void message(String string2) {
        Py.writeMessage("*sys-package-mgr*", string2);
    }

    protected void warning(String string2) {
        Py.writeWarning("*sys-package-mgr*", string2);
    }

    protected void comment(String string2) {
        Py.writeComment("*sys-package-mgr*", string2);
    }

    protected void debug(String string2) {
        Py.writeDebug("*sys-package-mgr*", string2);
    }

    public SysPackageManager(File file, Properties properties) {
        if (this.useCacheDir(file)) {
            this.initCache();
            this.findAllPackages(properties);
            this.saveCache();
        }
    }

    public void addJar(String string2, boolean bl) {
        this.addJarToPackages(new File(string2), bl);
        if (bl) {
            this.saveCache();
        }
    }

    public void addJarDir(String string2, boolean bl) {
        this.addJarDir(string2, bl, bl);
    }

    private void addJarDir(String string2, boolean bl, boolean bl2) {
        File file = new File(string2);
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.endsWith(".jar") && !string3.endsWith(".zip")) continue;
            this.addJarToPackages(new File(string2, string3), bl);
        }
        if (bl2) {
            this.saveCache();
        }
    }

    private void addJarPath(String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.addJarDir(string3, true, false);
        }
    }

    private void findAllPackages(Properties properties) {
        String string2;
        String string3;
        String string4 = properties.getProperty("python.packages.paths", "java.class.path,sun.boot.class.path");
        String string5 = properties.getProperty("python.packages.directories", "java.ext.dirs");
        String string6 = properties.getProperty("python.packages.fakepath", null);
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            string2 = properties.getProperty(string3);
            if (string2 == null) continue;
            this.addClassPath(string2);
        }
        stringTokenizer = new StringTokenizer(string5, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            string2 = properties.getProperty(string3);
            if (string2 == null) continue;
            this.addJarPath(string2);
        }
        if (string6 != null) {
            this.addClassPath(string6);
        }
    }

    public void notifyPackageImport(String string2, String string3) {
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + '.' + string3;
        }
        Py.writeComment("import", "'" + string3 + "' as java package");
    }

    public Class findClass(String string2, String string3) {
        Class clazz = super.findClass(string2, string3);
        if (clazz != null) {
            Py.writeComment("import", "'" + string3 + "' as java class");
        }
        return clazz;
    }

    public Class findClass(String string2, String string3, String string4) {
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + '.' + string3;
        }
        return Py.findClassEx(string3, string4);
    }

    public PyList doDir(PyJavaPackage pyJavaPackage, boolean bl, boolean bl2) {
        PyList pyList = this.basicDoDir(pyJavaPackage, bl, bl2);
        PyList pyList2 = new PyList();
        this.doDir(this.searchPath, pyList2, pyJavaPackage, bl, bl2);
        PySystemState pySystemState = Py.getSystemState();
        if (pySystemState.getClassLoader() == null) {
            this.doDir(pySystemState.path, pyList2, pyJavaPackage, bl, bl2);
        }
        return this.merge(pyList, pyList2);
    }

    public boolean packageExists(String string2, String string3) {
        if (this.packageExists(this.searchPath, string2, string3)) {
            return true;
        }
        PySystemState pySystemState = Py.getSystemState();
        return pySystemState.getClassLoader() == null && this.packageExists(Py.getSystemState().path, string2, string3);
    }
}

