/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Phrase;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.markup.MarkupParser;
import java.util.Properties;

public class Paragraph
extends Phrase
implements TextElementArray,
MarkupAttributes {
    private static final long serialVersionUID = 7852314969733375514L;
    protected int alignment = -1;
    protected float indentationLeft;
    protected float indentationRight;
    protected float spacingBefore;
    protected float spacingAfter;
    protected boolean keeptogether = false;
    protected float multipliedLeading = 0.0f;
    private float firstLineIndent = 0.0f;
    private float extraParagraphSpace = 0.0f;

    public Paragraph() {
    }

    public Paragraph(float f) {
        super(f);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float f, Chunk chunk) {
        super(f, chunk);
    }

    public Paragraph(String string2) {
        super(string2);
    }

    public Paragraph(String string2, Font font) {
        super(string2, font);
    }

    public Paragraph(float f, String string2) {
        super(f, string2);
    }

    public Paragraph(float f, String string2, Font font) {
        super(f, string2, font);
    }

    public Paragraph(Phrase phrase) {
        super(phrase.leading, "", phrase.font());
        super.add(phrase);
        if (phrase instanceof Paragraph) {
            Paragraph paragraph = (Paragraph)phrase;
            this.setAlignment(paragraph.alignment());
            this.setExtraParagraphSpace(paragraph.getExtraParagraphSpace());
            this.setFirstLineIndent(paragraph.getFirstLineIndent());
            this.setIndentationLeft(paragraph.indentationLeft());
            this.setIndentationRight(paragraph.indentationRight());
            this.setSpacingAfter(paragraph.spacingAfter());
            this.setSpacingBefore(paragraph.spacingBefore());
        }
    }

    public Paragraph(Properties properties) {
        this("", FontFactory.getFont(properties));
        String string2 = (String)properties.remove("itext");
        if (string2 != null) {
            Chunk chunk = new Chunk(string2);
            string2 = (String)properties.remove(ElementTags.GENERICTAG);
            if (string2 != null) {
                chunk.setGenericTag(string2);
            }
            this.add(chunk);
        }
        if ((string2 = (String)properties.remove("align")) != null) {
            this.setAlignment(string2);
        }
        if ((string2 = (String)properties.remove("leading")) != null) {
            this.setLeading(Float.parseFloat(string2 + "f"));
        } else {
            string2 = (String)properties.remove("line-height");
            if (string2 != null) {
                this.setLeading(MarkupParser.parseLength(string2));
            } else {
                this.setLeading(16.0f);
            }
        }
        string2 = (String)properties.remove("indentationleft");
        if (string2 != null) {
            this.setIndentationLeft(Float.parseFloat(string2 + "f"));
        }
        if ((string2 = (String)properties.remove("indentationright")) != null) {
            this.setIndentationRight(Float.parseFloat(string2 + "f"));
        }
        if ((string2 = (String)properties.remove("keeptogether")) != null) {
            this.keeptogether = Boolean.valueOf(string2);
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public int type() {
        return 12;
    }

    public boolean add(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            list.setIndentationLeft(list.indentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add(list);
        }
        if (object instanceof Image) {
            super.addSpecial(object);
            return true;
        }
        if (object instanceof Paragraph) {
            super.add(object);
            super.add(Chunk.NEWLINE);
            return true;
        }
        return super.add(object);
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setAlignment(String string2) {
        if ("Center".equalsIgnoreCase(string2)) {
            this.alignment = 1;
            return;
        }
        if ("Right".equalsIgnoreCase(string2)) {
            this.alignment = 2;
            return;
        }
        if ("Justify".equalsIgnoreCase(string2)) {
            this.alignment = 3;
            return;
        }
        if ("JustifyAll".equalsIgnoreCase(string2)) {
            this.alignment = 8;
            return;
        }
        this.alignment = 0;
    }

    public void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public void setSpacingBefore(float f) {
        this.spacingBefore = f;
    }

    public void setSpacingAfter(float f) {
        this.spacingAfter = f;
    }

    public void setKeepTogether(boolean bl) {
        this.keeptogether = bl;
    }

    public boolean getKeepTogether() {
        return this.keeptogether;
    }

    public int alignment() {
        return this.alignment;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public static boolean isTag(String string2) {
        return "paragraph".equals(string2);
    }

    public void setLeading(float f, float f2) {
        this.leading = f;
        this.multipliedLeading = f2;
    }

    public void setLeading(float f) {
        this.leading = f;
        this.multipliedLeading = 0.0f;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public float getFirstLineIndent() {
        return this.firstLineIndent;
    }

    public void setFirstLineIndent(float f) {
        this.firstLineIndent = f;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f) {
        this.extraParagraphSpace = f;
    }
}

