/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.map.NgramsForOrderIterableWrapper;
import edu.berkeley.nlp.lm.util.Logger;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NgramsForOrderMapWrapper<W, V>
extends AbstractMap<List<W>, V> {
    private final NgramMap<V> map;
    private final int ngramOrder;
    private final WordIndexer<W> wordIndexer;
    private final NgramsForOrderIterableWrapper<W, V> iterableWrapper;

    public NgramsForOrderMapWrapper(NgramMap<V> map, WordIndexer<W> wordIndexer, int ngramOrder) {
        this.map = map;
        this.ngramOrder = ngramOrder;
        this.wordIndexer = wordIndexer;
        this.iterableWrapper = new NgramsForOrderIterableWrapper<W, V>(map, wordIndexer, ngramOrder);
    }

    @Override
    public V get(Object arg0) {
        if (!(arg0 instanceof List)) {
            return null;
        }
        List l = (List)arg0;
        if (l.size() != this.ngramOrder + 1) {
            return null;
        }
        int[] ngram = WordIndexer.StaticMethods.toArray(this.wordIndexer, l);
        return this.getForArray(ngram);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public Set<Map.Entry<List<W>, V>> entrySet() {
        return new AbstractSet<Map.Entry<List<W>, V>>(){

            @Override
            public Iterator<Map.Entry<List<W>, V>> iterator() {
                return NgramsForOrderMapWrapper.this.iterableWrapper.iterator();
            }

            @Override
            public int size() {
                long size = NgramsForOrderMapWrapper.this.iterableWrapper.size();
                if (size > Integer.MAX_VALUE) {
                    Logger.warn(NgramsForOrderMapWrapper.class.getSimpleName() + " doesn't like maps with size greater than Integer.MAX_VALUE");
                }
                return (int)size;
            }
        };
    }

    private V getForArray(int[] ngram) {
        return this.map.get(ngram, 0, ngram.length);
    }
}

