/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest;

import com.google.inject.matcher.AbstractMatcher;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import org.apache.guacamole.GuacamoleException;

public class RESTMethodMatcher
extends AbstractMatcher<Method> {
    private boolean methodThrowsException(Method method, Class<? extends Exception> exceptionType) {
        for (Class<?> thrownType : method.getExceptionTypes()) {
            if (!exceptionType.isAssignableFrom(thrownType)) continue;
            return true;
        }
        return false;
    }

    private boolean isRESTMethod(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.isAnnotationPresent(HttpMethod.class)) {
                return true;
            }
            if (!Path.class.isAssignableFrom(annotationType)) continue;
            return true;
        }
        Class<?> superclass = method.getDeclaringClass().getSuperclass();
        if (superclass != null) {
            try {
                return this.isRESTMethod(superclass.getMethod(method.getName(), method.getParameterTypes()));
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return false;
    }

    public boolean matches(Method method) {
        return this.isRESTMethod(method) && this.methodThrowsException(method, GuacamoleException.class);
    }
}

