/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.event;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.proxy.event.IoSessionEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoSessionEvent {
    private static final Logger logger = LoggerFactory.getLogger(IoSessionEvent.class);
    private final IoFilter.NextFilter nextFilter;
    private final IoSession session;
    private final IoSessionEventType type;
    private IdleStatus status;

    public IoSessionEvent(IoFilter.NextFilter nextFilter, IoSession ioSession, IoSessionEventType ioSessionEventType) {
        this.nextFilter = nextFilter;
        this.session = ioSession;
        this.type = ioSessionEventType;
    }

    public IoSessionEvent(IoFilter.NextFilter nextFilter, IoSession ioSession, IdleStatus idleStatus) {
        this(nextFilter, ioSession, IoSessionEventType.IDLE);
        this.status = idleStatus;
    }

    public void deliverEvent() {
        logger.debug("Delivering event {}", (Object)this);
        IoSessionEvent.deliverEvent(this.nextFilter, this.session, this.type, this.status);
    }

    private static void deliverEvent(IoFilter.NextFilter nextFilter, IoSession ioSession, IoSessionEventType ioSessionEventType, IdleStatus idleStatus) {
        switch (ioSessionEventType) {
            case CREATED: {
                nextFilter.sessionCreated(ioSession);
                break;
            }
            case OPENED: {
                nextFilter.sessionOpened(ioSession);
                break;
            }
            case IDLE: {
                nextFilter.sessionIdle(ioSession, idleStatus);
                break;
            }
            case CLOSED: {
                nextFilter.sessionClosed(ioSession);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(IoSessionEvent.class.getSimpleName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append(" - [ ").append(this.session);
        stringBuilder.append(", ").append((Object)this.type);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public IoSessionEventType getType() {
        return this.type;
    }
}

