/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.service.AbstractIoService;

public class IoServiceStatistics {
    private AbstractIoService service;
    private final AtomicLong readBytes = new AtomicLong();
    private final AtomicLong writtenBytes = new AtomicLong();
    private final AtomicLong readMessages = new AtomicLong();
    private final AtomicLong writtenMessages = new AtomicLong();
    private long lastReadTime;
    private long lastWriteTime;
    private long lastThroughputCalculationTime;
    private final AtomicInteger scheduledWriteBytes = new AtomicInteger();
    private final AtomicInteger scheduledWriteMessages = new AtomicInteger();
    private int throughputCalculationInterval = 3;
    private final Object throughputCalculationLock = new Object();

    public IoServiceStatistics(AbstractIoService abstractIoService) {
        this.service = abstractIoService;
    }

    public final long getLastReadTime() {
        return this.lastReadTime;
    }

    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    protected final void setLastReadTime(long l) {
        this.lastReadTime = l;
    }

    protected final void setLastWriteTime(long l) {
        this.lastWriteTime = l;
    }

    public final void increaseReadBytes(long l, long l2) {
        this.readBytes.addAndGet(l);
        this.lastReadTime = l2;
    }

    public final void increaseReadMessages(long l) {
        this.readMessages.incrementAndGet();
        this.lastReadTime = l;
    }

    public final void increaseWrittenBytes(int n, long l) {
        this.writtenBytes.addAndGet(n);
        this.lastWriteTime = l;
    }

    public final void increaseWrittenMessages(long l) {
        this.writtenMessages.incrementAndGet();
        this.lastWriteTime = l;
    }

    public final void increaseScheduledWriteBytes(int n) {
        this.scheduledWriteBytes.addAndGet(n);
    }

    public final void increaseScheduledWriteMessages() {
        this.scheduledWriteMessages.incrementAndGet();
    }

    public final void decreaseScheduledWriteMessages() {
        this.scheduledWriteMessages.decrementAndGet();
    }

    protected void setLastThroughputCalculationTime(long l) {
        this.lastThroughputCalculationTime = l;
    }
}

