/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.binding.impl.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.namespace.QName;
import jlibs.core.lang.StringUtil;
import jlibs.core.lang.model.ModelUtil;
import jlibs.xml.sax.binding.Binding;
import jlibs.xml.sax.binding.Temp;
import jlibs.xml.sax.binding.impl.processor.Binding;
import jlibs.xml.sax.binding.impl.processor.BindingAnnotation;
import jlibs.xml.sax.binding.impl.processor.BindingRelation;

class BindingFinishAnnotation
extends BindingAnnotation {
    BindingFinishAnnotation() {
        super(Binding.Finish.class, "public void endElement(int state, SAXContext current) throws SAXException{");
    }

    @Override
    public void consume(Binding binding, ExecutableElement method, AnnotationMirror mirror) {
        super.consume(binding, method, mirror);
        for (AnnotationValue xpath : (Collection)ModelUtil.getAnnotationValue((Element)method, (AnnotationMirror)mirror, (String)"value")) {
            binding.getBinding((ExecutableElement)method, (AnnotationMirror)mirror, (String)((String)xpath.getValue())).finishMethod = method;
        }
    }

    @Override
    public String lvalue(ExecutableElement method) {
        if (method.getReturnType().getKind() == TypeKind.VOID) {
            return "";
        }
        return "current.object = ";
    }

    @Override
    public String params(ExecutableElement method) {
        ArrayList<String> params = new ArrayList<String>();
        for (VariableElement variableElement : method.getParameters()) {
            AnnotationMirror mirror = ModelUtil.getAnnotationMirror((Element)variableElement, Temp.class);
            if (mirror == null) {
                params.add(this.context(variableElement, false));
                continue;
            }
            String value = (String)ModelUtil.getAnnotationValue((Element)variableElement, (AnnotationMirror)mirror, (String)"value");
            if (value.length() == 0) {
                value = variableElement.getSimpleName().toString();
            }
            QName qname = Binding.toQName(variableElement, mirror, value);
            StringBuilder buff = new StringBuilder();
            buff.append("(").append(ModelUtil.toString((TypeMirror)variableElement.asType(), (boolean)true)).append(")");
            buff.append("current.get(");
            buff.append('\"').append(qname.getNamespaceURI()).append("\", ");
            buff.append('\"').append(qname.getLocalPart()).append('\"');
            buff.append(")");
            params.add(buff.toString());
        }
        return StringUtil.join(params.iterator());
    }

    @Override
    boolean getMethods(Binding binding, List<ExecutableElement> methods) {
        boolean nonEmpty = binding.finishMethod != null;
        methods.add(binding.finishMethod);
        for (BindingRelation bindingRelation : binding.registry.values()) {
            nonEmpty |= this.getMethods(bindingRelation.binding, methods);
        }
        return nonEmpty;
    }
}

