/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import jlibs.xml.NamespaceMap;
import jlibs.xml.QNameFake;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class SAXContext<T> {
    public T object;
    public Map<QName, Object> temp;
    protected QNameFake qnameFake;
    protected NamespaceMap namespaceMap;
    protected QName element;

    public Map<QName, Object> temp() {
        if (this.temp == null) {
            this.temp = new HashMap<QName, Object>();
        }
        return this.temp;
    }

    public NamespaceMap namespaceMap() {
        return this.namespaceMap;
    }

    public QName element() {
        return this.element;
    }

    public void put(QName qname, Object value) {
        if (value != null) {
            this.temp().put(qname, value);
        }
    }

    public void add(QName qname, Object value) {
        if (value != null) {
            this.temp();
            ArrayList<Object> list = (ArrayList<Object>)this.temp.get(qname);
            if (list == null) {
                list = new ArrayList<Object>();
                this.temp.put(qname, list);
            }
            list.add(value);
        }
    }

    public void putAttributes(Attributes attributes) {
        int attrCount = attributes.getLength();
        if (attrCount > 0) {
            this.temp();
            for (int i = 0; i < attrCount; ++i) {
                QName qname = new QName(attributes.getURI(i), attributes.getLocalName(i));
                this.temp.put(qname, attributes.getValue(i));
            }
        }
    }

    public void putAttribute(Attributes attributes, QName qname) {
        String value = attributes.getValue(qname.getNamespaceURI(), qname.getLocalPart());
        if (value != null) {
            this.put(qname, value);
        }
    }

    public void addAttributes(Attributes attributes) {
        int attrCount = attributes.getLength();
        if (attrCount > 0) {
            this.temp();
            for (int i = 0; i < attrCount; ++i) {
                QName qname = new QName(attributes.getURI(i), attributes.getLocalName(i));
                this.add(qname, attributes.getValue(i));
            }
        }
    }

    public void addAttribute(Attributes attributes, QName qname) {
        String value = attributes.getValue(qname.getNamespaceURI(), qname.getLocalPart());
        if (value != null) {
            this.add(qname, value);
        }
    }

    public <X> X get(String namespaceURI, String localPart) {
        return (X)this.get(namespaceURI, localPart, null);
    }

    public <X> X get(String namespaceURI, String localPart, X defaultValue) {
        if (this.temp == null) {
            return defaultValue;
        }
        Object value = this.temp.get(this.qnameFake.set(namespaceURI, localPart));
        return (X)(value != null ? value : defaultValue);
    }

    public abstract String xpath();

    public abstract Locator locator();

    public String toString() {
        return this.xpath() + " (line=" + this.locator().getLineNumber() + ", col=" + this.locator().getColumnNumber() + ')';
    }
}

