/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import java.util.Map;
import jlibs.xml.NamespaceMap;
import jlibs.xml.sax.SAXDelegate;
import org.xml.sax.SAXException;

class Namespaces {
    private NamespaceMap namespaces = new NamespaceMap();
    private NamespaceMap freeNamespaces;
    private SAXDelegate handler;

    public Namespaces(SAXDelegate handler) {
        this.handler = handler;
    }

    public void reset() {
        if (this.namespaces.parent() != null) {
            this.namespaces = new NamespaceMap();
        }
    }

    public String getNamespaceURI(String prefix) {
        return this.namespaces.getNamespaceURI(prefix);
    }

    public void push() {
        if (this.freeNamespaces != null) {
            NamespaceMap newOne = this.freeNamespaces;
            this.freeNamespaces = this.freeNamespaces.parent();
            newOne.setParent(this.namespaces);
            this.namespaces = newOne;
        } else {
            this.namespaces = new NamespaceMap(this.namespaces);
        }
    }

    public void add(String prefix, String namespace) throws SAXException {
        this.namespaces.put(prefix, namespace);
        this.handler.startPrefixMapping(prefix, namespace);
    }

    public void pop() throws SAXException {
        Map map = this.namespaces.map();
        if (map != null && map.size() > 0) {
            for (String nsPrefix : map.keySet()) {
                this.handler.endPrefixMapping(nsPrefix);
            }
            map.clear();
        }
        NamespaceMap current = this.namespaces;
        this.namespaces = this.namespaces.parent();
        current.setParent(this.freeNamespaces);
        this.freeNamespaces = current;
    }
}

