/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class SAXUtil {
    public static SAXParserFactory newSAXFactory(boolean namespaces, boolean nsPrefixes, boolean validating) throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(namespaces);
        if (nsPrefixes) {
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        factory.setValidating(validating);
        return factory;
    }

    public static SAXParser newSAXParser(boolean namespaces, boolean nsPrefixes, boolean validating) throws ParserConfigurationException, SAXException {
        return SAXUtil.newSAXFactory(namespaces, nsPrefixes, validating).newSAXParser();
    }

    public static void setHandler(XMLReader reader, Object handler) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (handler instanceof ContentHandler) {
            reader.setContentHandler((ContentHandler)handler);
        }
        if (handler instanceof EntityResolver) {
            reader.setEntityResolver((EntityResolver)handler);
        }
        if (handler instanceof ErrorHandler) {
            reader.setErrorHandler((ErrorHandler)handler);
        }
        if (handler instanceof DTDHandler) {
            reader.setDTDHandler((DTDHandler)handler);
        }
        if (handler instanceof LexicalHandler) {
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXException ex) {
                reader.setProperty("http://xml.org/sax/handlers/LexicalHandler", handler);
            }
        }
        if (handler instanceof DeclHandler) {
            try {
                reader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
            }
            catch (SAXException ex) {
                reader.setProperty("http://xml.org/sax/handlers/DeclHandler", handler);
            }
        }
    }
}

