/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.dom;

import javax.xml.namespace.NamespaceContext;
import jlibs.core.graph.Convertor;
import jlibs.core.graph.Navigator2;
import jlibs.core.graph.PredicateConvertor;
import jlibs.core.graph.Sequence;
import jlibs.core.graph.sequences.ConcatSequence;
import jlibs.xml.dom.DOMXPathNameConvertor;
import jlibs.xml.dom.NamedNodeMapSequence;
import jlibs.xml.dom.NodeListSequence;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMNavigator
extends Navigator2<Node> {
    public Node parent(Node node) {
        if (node instanceof Attr) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    public Sequence<? extends Node> children(Node node) {
        NodeListSequence seq = new NodeListSequence(node.getChildNodes());
        if (node instanceof Element) {
            Element elem = (Element)node;
            seq = new ConcatSequence(new Sequence[]{new NamedNodeMapSequence(elem.getAttributes()), seq});
        }
        return seq;
    }

    public String getXPath(Node node, NamespaceContext nsContext) {
        if (node instanceof Document) {
            return "/";
        }
        return this.getPath(node, (Convertor)new XPathConvertor(nsContext), "/");
    }

    private class XPathConvertor
    extends PredicateConvertor<Node> {
        public XPathConvertor(NamespaceContext nsContext) {
            super((Navigator2)DOMNavigator.this, (Convertor)new DOMXPathNameConvertor(nsContext));
        }

        public String convert(Node source) {
            switch (source.getNodeType()) {
                case 2: 
                case 13: {
                    return (String)this.delegate.convert((Object)source);
                }
            }
            return super.convert((Object)source);
        }
    }
}

