/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsIconFactory;
import com.pagosoft.plaf.PgsUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class PgsMenuItemUI
extends BasicMenuItemUI {
    private PropertyChangeListener menuItemIconChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new PgsMenuItemUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.menuItem.getIcon() == null) {
            this.menuItem.setIcon(PgsIconFactory.getEmptyIcon());
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.menuItemIconChangeListener == null) {
            this.menuItemIconChangeListener = new IconChangeListener(this.menuItem);
        }
        this.menuItem.addPropertyChangeListener("icon", this.menuItemIconChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener("icon", this.menuItemIconChangeListener);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        PgsUtils.paintMenuItemBackground(g, menuItem, bgColor, this.getPropertyPrefix());
    }

    @Override
    protected void paintText(Graphics g, JMenuItem c, Rectangle textRect, String text) {
        PgsUtils.installAntialiasing(g);
        super.paintText(g, c, textRect, text);
        PgsUtils.uninstallAntialiasing(g);
    }

    public static class IconChangeListener
    implements PropertyChangeListener {
        private AbstractButton button;

        public IconChangeListener(AbstractButton item) {
            this.button = item;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.button.getClientProperty("allow.no.icon") == null && this.button.getIcon() == null) {
                this.button.setIcon(PgsIconFactory.getEmptyIcon());
            }
        }
    }
}

