/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.userprefs;

import com.jgoodies.common.collect.ArrayListModel;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.swing.SwingXUtils;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.swingx.hyperlink.LinkModel;

class PluginMetaDataTableModel
extends AbstractTableModel
implements ListDataListener {
    private final ArrayListModel<PluginMetaData> model;
    private final String[] columns;
    static final int COLUMN_ACTIVE = 0;
    static final int COLUMN_UPDATE = 1;
    static final int COLUMN_CLIPBOARD_MONITORED = 2;
    static final int COLUMN_ID = 3;
    static final int COLUMN_VERSION = 4;
    static final int COLUMN_SERVICES = 5;
    static final int COLUMN_AUTHOR = 6;
    static final int COLUMN_MAX_PARALEL_DOWNLOADS = 7;
    static final int COLUMN_PRIORITY = 8;
    static final int COLUMN_WWW = 9;

    public PluginMetaDataTableModel(ArrayListModel<PluginMetaData> model, String[] columns) {
        this.model = model;
        this.columns = columns;
        model.addListDataListener(this);
    }

    @Override
    public int getRowCount() {
        return this.model.getSize();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 || columnIndex == 1 || columnIndex == 8 || columnIndex == 7 || columnIndex == 2;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 || columnIndex == 1 || columnIndex == 2) {
            return Boolean.class;
        }
        if (columnIndex == 8 || columnIndex == 7) {
            return Integer.class;
        }
        if (columnIndex == 9) {
            return LinkModel.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PluginMetaData data = (PluginMetaData)this.model.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return data.isEnabled();
            }
            case 1: {
                return data.isUpdatesEnabled();
            }
            case 2: {
                return data.isClipboardMonitored();
            }
            case 3: {
                return data.getId();
            }
            case 4: {
                return data.getVersion();
            }
            case 5: {
                return data.getServices();
            }
            case 6: {
                return data.getVendor();
            }
            case 7: {
                return data.getMaxAllowedDownloads();
            }
            case 8: {
                return data.getPluginPriority();
            }
            case 9: {
                return SwingXUtils.createLink(data.getWWW());
            }
        }
        assert (false);
        return data;
    }

    public PluginMetaData getObject(int rowIndex) {
        return (PluginMetaData)this.model.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        PluginMetaData data = (PluginMetaData)this.model.get(rowIndex);
        if (columnIndex == 0) {
            data.setEnabled((Boolean)aValue);
        } else if (columnIndex == 1) {
            data.setUpdatesEnabled((Boolean)aValue);
        } else if (columnIndex == 8) {
            data.setPluginPriority((Integer)aValue);
        } else if (columnIndex == 7) {
            data.setMaxAllowedDownloads((Integer)aValue);
        } else if (columnIndex == 2) {
            data.setClipboardMonitored((Boolean)aValue);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
    }

    public PluginMetaData getMetaValueAt(int row) {
        return (PluginMetaData)this.model.get(row);
    }
}

