/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content.comparators;

import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.content.comparators.NameColumnComparator;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.util.Comparator;

public final class EstTimeColumnComparator
implements Comparator<DownloadFile> {
    private NameColumnComparator nameComparator = new NameColumnComparator();

    @Override
    public final int compare(DownloadFile o1, DownloadFile o2) {
        int res;
        DownloadState state1 = o1.getState();
        DownloadState state2 = o2.getState();
        boolean isProcessState1 = DownloadsActions.isProcessState(state1);
        boolean isProcessState2 = DownloadsActions.isProcessState(state2);
        if (isProcessState1 && !isProcessState2) {
            return -1;
        }
        if (!isProcessState1 && isProcessState2) {
            return 1;
        }
        int p1 = DownloadsActions.getPriorityForState(state1);
        int p2 = DownloadsActions.getPriorityForState(state2);
        if (!isProcessState1 && (res = new Integer(p1).compareTo(p2)) == 0) {
            return this.nameComparator.compare(o1, o2);
        }
        if (p1 == p2) {
            boolean compare2;
            long hasToBeDownloaded = o1.getFileSize() - o1.getDownloaded();
            double avgSpeed = o1.getShortTimeAvgSpeed();
            boolean compare1 = hasToBeDownloaded >= 0L && avgSpeed > 0.0;
            long hasToBeDownloaded2 = o1.getFileSize() - o1.getDownloaded();
            double avgSpeed2 = o2.getShortTimeAvgSpeed();
            boolean bl = compare2 = hasToBeDownloaded2 >= 0L && avgSpeed2 > 0.0;
            if (compare1 && !compare2) {
                return -1;
            }
            if (!compare1 && compare2) {
                return 1;
            }
            if (compare1 && compare2) {
                long value1 = Math.round((double)hasToBeDownloaded / avgSpeed);
                long value2 = Math.round((double)hasToBeDownloaded2 / avgSpeed2);
                return -new Long(value1).compareTo(value2);
            }
            return this.nameComparator.compare(o1, o2);
        }
        return new Integer(p1).compareTo(p2);
    }
}

