/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.OneInstanceServer;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.EventObject;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

final class OneInstanceClient {
    private static final Logger logger = Logger.getLogger(OneInstanceClient.class.getName());

    private OneInstanceClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkInstance(Collection<String> openFiles, AppPrefs prefs, ApplicationContext context) {
        if (!AppPrefs.getProperty("oneinstance", true)) {
            return false;
        }
        Socket clientSocket = null;
        try {
            logger.info("Testing existing instance");
            String portString = AppPrefs.getProperty("oneInstanceServerPort", null);
            if (portString != null) {
                block28: {
                    clientSocket = new Socket("localhost", Integer.parseInt(portString));
                    if (openFiles != null && !openFiles.isEmpty()) {
                        OutputStream out = null;
                        try {
                            out = clientSocket.getOutputStream();
                            if (out != null) {
                                for (String file : openFiles) {
                                    out.write(file.getBytes());
                                    out.write(10);
                                }
                                out.close();
                            }
                        }
                        catch (IOException e) {
                            LogUtils.processException(logger, e);
                            if (out == null) break block28;
                            try {
                                out.close();
                            }
                            catch (Exception ex) {
                                LogUtils.processException(logger, ex);
                            }
                        }
                    }
                }
                if (AppPrefs.getProperty("showPaypalRequest", 13) != 14) {
                    logger.warning("Detecting ESET - disabling OneInstance functionality");
                    AppPrefs.storeProperty("oneinstance", false);
                    boolean bl = false;
                    return bl;
                }
                logger.info("Application is already running. Exiting");
                boolean bl = true;
                return bl;
            }
            logger.info("No other instance is running - first instance");
            OneInstanceClient.oneInstanceServerStart(prefs, context);
        }
        catch (IOException e) {
            logger.info("No other instance is running.");
            OneInstanceClient.oneInstanceServerStart(prefs, context);
        }
        finally {
            if (clientSocket != null) {
                try {
                    clientSocket.close();
                }
                catch (IOException e) {
                    LogUtils.processException(logger, e);
                }
            }
        }
        return false;
    }

    private static void oneInstanceServerStart(AppPrefs prefs, ApplicationContext context) {
        final OneInstanceServer server = new OneInstanceServer(prefs);
        server.start();
        context.getApplication().addExitListener(new Application.ExitListener(){

            @Override
            public boolean canExit(EventObject event) {
                return true;
            }

            @Override
            public void willExit(EventObject event) {
                ServerSocket serverSocket = server.getServerSocket();
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

