/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import jlibs.core.io.ByteArrayOutputStream2;
import jlibs.core.io.CharArrayWriter2;

public class IOUtil {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset UTF_16 = Charset.forName("UTF-16");

    public static ByteArrayOutputStream2 pump(InputStream is, boolean closeIn) throws IOException {
        return IOUtil.pump(is, new ByteArrayOutputStream2(), closeIn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends OutputStream> T pump(InputStream is, T os, boolean closeIn, boolean closeOut) throws IOException {
        byte[] buff = new byte[1024];
        Exception exception = null;
        try {
            int len;
            while ((len = is.read(buff)) != -1) {
                os.write(buff, 0, len);
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            try {
                try {
                    if (closeIn) {
                        is.close();
                    }
                }
                finally {
                    if (closeOut) {
                        os.close();
                    }
                }
            }
            catch (IOException ex) {
                if (exception != null) {
                    ex.printStackTrace();
                }
                exception = ex;
            }
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        return os;
    }

    public static CharArrayWriter2 pump(Reader reader, boolean closeReader) throws IOException {
        return IOUtil.pump(reader, new CharArrayWriter2(), closeReader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Writer> T pump(Reader reader, T writer, boolean closeReader, boolean closeWriter) throws IOException {
        char[] buff = new char[1024];
        Exception exception = null;
        try {
            int len;
            while ((len = reader.read(buff)) != -1) {
                writer.write(buff, 0, len);
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            try {
                try {
                    if (closeReader) {
                        reader.close();
                    }
                }
                finally {
                    if (closeWriter) {
                        writer.close();
                    }
                }
            }
            catch (IOException ex) {
                if (exception != null) {
                    ex.printStackTrace();
                }
                exception = ex;
            }
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        return writer;
    }

    public static int readFully(InputStream in, byte[] b) throws IOException {
        return IOUtil.readFully(in, b, 0, b.length);
    }

    public static int readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < len; n += count) {
            count = in.read(b, off + n, len - n);
            if (count >= 0) continue;
            return n;
        }
        return n;
    }

    public static int readFully(Reader reader, char[] ch) throws IOException {
        return IOUtil.readFully(reader, ch, 0, ch.length);
    }

    public static int readFully(Reader reader, char[] ch, int off, int len) throws IOException {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < len; n += count) {
            count = reader.read(ch, off + n, len - n);
            if (count >= 0) continue;
            return n;
        }
        return n;
    }
}

