/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JaiI18N;

public class JPEGEncodeParam
implements ImageEncodeParam {
    private static int JPEG_MAX_BANDS = 3;
    private int[] hSamp = new int[JPEG_MAX_BANDS];
    private int[] vSamp = new int[JPEG_MAX_BANDS];
    private int[][] qTab;
    private int[] qTabSlot = new int[JPEG_MAX_BANDS];
    private float qual;
    private int rstInterval;
    private boolean writeImageOnly;
    private boolean writeTablesOnly;
    private boolean writeJFIFHeader;
    private boolean qualitySet;
    private boolean[] qTabSet;

    public JPEGEncodeParam() {
        this.qTab = new int[JPEG_MAX_BANDS][];
        this.qTabSet = new boolean[JPEG_MAX_BANDS];
        this.hSamp[0] = 1;
        this.vSamp[0] = 1;
        this.qTabSlot[0] = 0;
        this.qTab[0] = null;
        this.qTabSet[0] = false;
        this.hSamp[1] = 2;
        this.vSamp[1] = 2;
        this.qTabSlot[1] = 1;
        this.qTab[1] = null;
        this.qTabSet[1] = false;
        this.hSamp[2] = 2;
        this.vSamp[2] = 2;
        this.qTabSlot[2] = 1;
        this.qTab[2] = null;
        this.qTabSet[2] = false;
        this.qual = 0.75f;
        this.rstInterval = 0;
        this.writeImageOnly = false;
        this.writeTablesOnly = false;
        this.writeJFIFHeader = true;
    }

    public void setHorizontalSubsampling(int n, int n2) {
        this.hSamp[n] = n2;
    }

    public int getHorizontalSubsampling(int n) {
        return this.hSamp[n];
    }

    public void setVerticalSubsampling(int n, int n2) {
        this.vSamp[n] = n2;
    }

    public int getVerticalSubsampling(int n) {
        return this.vSamp[n];
    }

    public void setLumaQTable(int[] nArray) {
        this.setQTable(0, 0, nArray);
        this.qTabSet[0] = true;
        this.qualitySet = false;
    }

    public void setChromaQTable(int[] nArray) {
        this.setQTable(1, 1, nArray);
        this.setQTable(2, 1, nArray);
        this.qTabSet[1] = true;
        this.qTabSet[2] = true;
        this.qualitySet = false;
    }

    public void setQTable(int n, int n2, int[] nArray) {
        this.qTab[n] = (int[])nArray.clone();
        this.qTabSlot[n] = n2;
        this.qTabSet[n] = true;
        this.qualitySet = false;
    }

    public boolean isQTableSet(int n) {
        return this.qTabSet[n];
    }

    public int[] getQTable(int n) {
        if (!this.qTabSet[n]) {
            throw new IllegalStateException(JaiI18N.getString("JPEGEncodeParam0"));
        }
        return this.qTab[n];
    }

    public int getQTableSlot(int n) {
        if (!this.qTabSet[n]) {
            throw new IllegalStateException(JaiI18N.getString("JPEGEncodeParam0"));
        }
        return this.qTabSlot[n];
    }

    public void setRestartInterval(int n) {
        this.rstInterval = n;
    }

    public int getRestartInterval() {
        return this.rstInterval;
    }

    public void setQuality(float f) {
        this.qual = f;
        for (int i = 0; i < JPEG_MAX_BANDS; ++i) {
            this.qTabSet[i] = false;
        }
        this.qualitySet = true;
    }

    public boolean isQualitySet() {
        return this.qualitySet;
    }

    public float getQuality() {
        return this.qual;
    }

    public void setWriteTablesOnly(boolean bl) {
        this.writeTablesOnly = bl;
    }

    public boolean getWriteTablesOnly() {
        return this.writeTablesOnly;
    }

    public void setWriteImageOnly(boolean bl) {
        this.writeImageOnly = bl;
    }

    public boolean getWriteImageOnly() {
        return this.writeImageOnly;
    }

    public void setWriteJFIFHeader(boolean bl) {
        this.writeJFIFHeader = bl;
    }

    public boolean getWriteJFIFHeader() {
        return this.writeJFIFHeader;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

