/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exchange.NetworkDownException;
import davmail.ui.tray.AwtGatewayTray;
import davmail.ui.tray.DavGatewayTrayInterface;
import davmail.ui.tray.FrameGatewayTray;
import davmail.ui.tray.OSXAwtGatewayTray;
import davmail.ui.tray.OSXFrameGatewayTray;
import davmail.ui.tray.SwtGatewayTray;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.lf5.LF5Appender;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;

public final class DavGatewayTray {
    private static final Logger LOGGER = Logger.getLogger((String)"davmail");
    private static final long ICON_SWITCH_MINIMUM_DELAY = 250L;
    private static long lastIconSwitch;
    static DavGatewayTrayInterface davGatewayTray;

    private DavGatewayTray() {
    }

    public static List<Image> getFrameIcons() {
        List<Image> icons = null;
        if (davGatewayTray != null) {
            icons = davGatewayTray.getFrameIcons();
        }
        return icons;
    }

    public static void switchIcon() {
        if (davGatewayTray != null && !Settings.getBooleanProperty("davmail.disableTrayActivitySwitch") && System.currentTimeMillis() - lastIconSwitch > 250L) {
            davGatewayTray.switchIcon();
            lastIconSwitch = System.currentTimeMillis();
        }
    }

    public static void resetIcon() {
        if (davGatewayTray != null && DavGatewayTray.isActive()) {
            davGatewayTray.resetIcon();
        }
    }

    public static boolean isActive() {
        return davGatewayTray == null || davGatewayTray.isActive();
    }

    private static void displayMessage(BundleMessage message, Level level) {
        LOGGER.log((Priority)level, (Object)message.formatLog());
        if (davGatewayTray != null && !Settings.getBooleanProperty("davmail.disableGuiNotifications")) {
            davGatewayTray.displayMessage(message.format(), level);
        }
    }

    private static void displayMessage(BundleMessage message, Exception e, Level level) {
        if (e instanceof NetworkDownException) {
            LOGGER.log((Priority)level, (Object)BundleMessage.getExceptionLogMessage(message, e));
        } else {
            LOGGER.log((Priority)level, (Object)BundleMessage.getExceptionLogMessage(message, e), (Throwable)e);
        }
        if (davGatewayTray != null && !Settings.getBooleanProperty("davmail.disableGuiNotifications") && !(e instanceof NetworkDownException)) {
            davGatewayTray.displayMessage(BundleMessage.getExceptionMessage(message, e), level);
        }
        if (davGatewayTray != null && e instanceof NetworkDownException) {
            davGatewayTray.inactiveIcon();
        }
    }

    public static void debug(BundleMessage message) {
        DavGatewayTray.displayMessage(message, Level.DEBUG);
    }

    public static void info(BundleMessage message) {
        DavGatewayTray.displayMessage(message, Level.INFO);
    }

    public static void warn(BundleMessage message) {
        DavGatewayTray.displayMessage(message, Level.WARN);
    }

    public static void warn(Exception e) {
        DavGatewayTray.displayMessage(null, e, Level.WARN);
    }

    public static void error(BundleMessage message) {
        DavGatewayTray.displayMessage(message, Level.ERROR);
    }

    public static void log(Exception e) {
        if (e instanceof NetworkDownException) {
            DavGatewayTray.warn(e);
        } else {
            DavGatewayTray.error(e);
        }
    }

    public static void error(Exception e) {
        DavGatewayTray.displayMessage(null, e, Level.ERROR);
    }

    public static void debug(BundleMessage message, Exception e) {
        DavGatewayTray.displayMessage(message, e, Level.DEBUG);
    }

    public static void warn(BundleMessage message, Exception e) {
        DavGatewayTray.displayMessage(message, e, Level.WARN);
    }

    public static void error(BundleMessage message, Exception e) {
        DavGatewayTray.displayMessage(message, e, Level.ERROR);
    }

    public static void init(boolean notray) {
        String currentDesktop = System.getenv("XDG_CURRENT_DESKTOP");
        String javaVersion = System.getProperty("java.version");
        String arch = System.getProperty("sun.arch.data.model");
        LOGGER.debug((Object)("OS Name: " + System.getProperty("os.name") + " Java version: " + javaVersion + (arch != null ? ' ' + arch : "") + " System tray " + (SystemTray.isSupported() ? "" : "not ") + "supported " + (currentDesktop == null ? "" : "Current Desktop: " + currentDesktop)));
        if (Settings.isLinux()) {
            System.setProperty("awt.useSystemAAFontSettings", "on");
            System.setProperty("swing.aatext", "true");
        }
        if (!Settings.getBooleanProperty("davmail.server")) {
            if ("GNOME-Classic:GNOME".equals(currentDesktop) || "ubuntu:GNOME".equals(currentDesktop)) {
                LOGGER.info((Object)"System tray is not supported on Gnome, will switch to frame mode");
            } else if (!notray) {
                if ("Unity".equals(currentDesktop)) {
                    LOGGER.info((Object)"Detected Unity desktop, please follow instructions at http://davmail.sourceforge.net/linuxsetup.html to restore normal systray or run DavMail in server mode");
                }
                if ("O365Interactive".equals(Settings.getProperty("davmail.mode"))) {
                    LOGGER.info((Object)"O365Interactive is not compatible with SWT, do not try to create SWT tray");
                } else {
                    ClassLoader classloader = DavGatewayTray.class.getClassLoader();
                    try {
                        classloader.loadClass("org.eclipse.swt.SWT");
                        davGatewayTray = new SwtGatewayTray();
                        davGatewayTray.init();
                    }
                    catch (ClassNotFoundException e) {
                        DavGatewayTray.info(new BundleMessage("LOG_SWT_NOT_AVAILABLE", new Object[0]));
                    }
                    catch (Throwable e) {
                        DavGatewayTray.info(new BundleMessage("LOG_SWT_NOT_AVAILABLE", new Object[0]));
                        davGatewayTray = null;
                    }
                }
                if (davGatewayTray == null) {
                    try {
                        if (SystemTray.isSupported()) {
                            davGatewayTray = DavGatewayTray.isOSX() ? new OSXAwtGatewayTray() : new AwtGatewayTray();
                            davGatewayTray.init();
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        DavGatewayTray.info(new BundleMessage("LOG_SYSTEM_TRAY_NOT_AVAILABLE", new Object[0]));
                    }
                }
            }
            if (davGatewayTray == null) {
                davGatewayTray = DavGatewayTray.isOSX() ? new OSXFrameGatewayTray() : new FrameGatewayTray();
                davGatewayTray.init();
            }
        }
    }

    public static boolean isOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static BufferedImage loadImage(String fileName) {
        BufferedImage result = null;
        try {
            ClassLoader classloader = DavGatewayTray.class.getClassLoader();
            URL imageUrl = classloader.getResource(fileName);
            if (imageUrl == null) {
                throw new IOException("Missing resource: " + fileName);
            }
            result = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_LOAD_IMAGE", new Object[0]), e);
        }
        return result;
    }

    public static BufferedImage adjustTrayIcon(BufferedImage image) {
        Color backgroundColor = null;
        String backgroundColorString = Settings.getProperty("davmail.trayBackgroundColor");
        String xdgCurrentDesktop = System.getenv("XDG_CURRENT_DESKTOP");
        boolean isKDE = "KDE".equals(xdgCurrentDesktop);
        boolean isXFCE = "XFCE".equals(xdgCurrentDesktop);
        boolean isUnity = "Unity".equals(xdgCurrentDesktop);
        boolean isCinnamon = "X-Cinnamon".equals(xdgCurrentDesktop);
        if (backgroundColorString == null || backgroundColorString.length() == 0) {
            if (isKDE) {
                backgroundColorString = "#DDF6E8";
            }
            if (isUnity) {
                backgroundColorString = "#4D4B45";
            }
            if (isXFCE) {
                backgroundColorString = "#E8E8E7";
            }
            if (isCinnamon) {
                backgroundColorString = "#2E2E2E";
            }
        }
        int imageType = 2;
        if (backgroundColorString != null && backgroundColorString.length() == 7 && backgroundColorString.startsWith("#")) {
            int red = Integer.parseInt(backgroundColorString.substring(1, 3), 16);
            int green = Integer.parseInt(backgroundColorString.substring(3, 5), 16);
            int blue = Integer.parseInt(backgroundColorString.substring(5, 7), 16);
            backgroundColor = new Color(red, green, blue);
            imageType = 1;
        }
        if (backgroundColor != null || isKDE || isUnity || isXFCE) {
            int width = image.getWidth();
            int height = image.getHeight();
            int x = 0;
            int y = 0;
            if (isKDE || isXFCE) {
                width = 22;
                height = 22;
                x = 3;
                y = 3;
            } else if (isUnity) {
                width = 22;
                height = 24;
                x = 4;
                y = 4;
            } else if (isCinnamon) {
                width = 24;
                height = 24;
                x = 4;
                y = 4;
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, imageType);
            Graphics2D graphics = bufferedImage.createGraphics();
            graphics.setColor(backgroundColor);
            graphics.fillRect(0, 0, width, height);
            graphics.drawImage((Image)image, x, y, null);
            graphics.dispose();
            return bufferedImage;
        }
        return image;
    }

    public static void dispose() {
        if (davGatewayTray != null) {
            davGatewayTray.dispose();
        }
    }

    public static void showLogs() {
        Logger rootLogger = Logger.getRootLogger();
        LF5Appender lf5Appender = (LF5Appender)rootLogger.getAppender("LF5Appender");
        if (lf5Appender == null) {
            LogBrokerMonitor logBrokerMonitor = new LogBrokerMonitor(LogLevel.getLog4JLevels()){

                protected void closeAfterConfirm() {
                    this.hide();
                }
            };
            lf5Appender = new LF5Appender(logBrokerMonitor);
            lf5Appender.setName("LF5Appender");
            rootLogger.addAppender((Appender)lf5Appender);
        }
        lf5Appender.getLogBrokerMonitor().show();
    }
}

