/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.exchange.XMLStreamUtil;
import davmail.exchange.ews.EWSMethod;
import davmail.exchange.ews.ElementOption;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ExpandDLMethod
extends EWSMethod {
    public ExpandDLMethod(String value) {
        super("Mailbox", "ExpandDL", "ExpandDLResponseMessage");
        this.unresolvedEntry = new ElementOption("m:Mailbox", new ElementOption("t:EmailAddress", value));
    }

    @Override
    protected EWSMethod.Item handleItem(XMLStreamReader reader) throws XMLStreamException {
        EWSMethod.Item responseItem = new EWSMethod.Item();
        responseItem.type = "Contact";
        while (reader.hasNext() && !XMLStreamUtil.isStartTag(reader, "Resolution")) {
            reader.next();
        }
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Resolution")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("Mailbox".equals(tagLocalName)) {
                this.handleMailbox(reader, responseItem);
                continue;
            }
            if (!"Contact".equals(tagLocalName)) continue;
            this.handleContact(reader, responseItem);
        }
        return responseItem;
    }

    protected void handleMailbox(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Mailbox")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("Name".equals(tagLocalName)) {
                responseItem.put(tagLocalName, XMLStreamUtil.getElementText(reader));
                continue;
            }
            if (!"EmailAddress".equals(tagLocalName)) continue;
            responseItem.put(tagLocalName, XMLStreamUtil.getElementText(reader));
        }
    }

    protected void handleContact(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Contact")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("EmailAddresses".equals(tagLocalName)) {
                this.handleEmailAddresses(reader, responseItem);
                continue;
            }
            if ("PhysicalAddresses".equals(tagLocalName)) {
                this.handlePhysicalAddresses(reader, responseItem);
                continue;
            }
            if ("PhoneNumbers".equals(tagLocalName)) {
                this.handlePhoneNumbers(reader, responseItem);
                continue;
            }
            responseItem.put(tagLocalName, XMLStreamUtil.getElementText(reader));
        }
    }

    protected void handlePhysicalAddress(XMLStreamReader reader, EWSMethod.Item responseItem, String addressType) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Entry")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            String value = XMLStreamUtil.getElementText(reader);
            responseItem.put(addressType + tagLocalName, value);
        }
    }

    protected void handlePhysicalAddresses(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "PhysicalAddresses")) {
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Entry".equals(tagLocalName = reader.getLocalName())) continue;
            String key = this.getAttributeValue(reader, "Key");
            this.handlePhysicalAddress(reader, responseItem, key);
        }
    }

    protected void handlePhoneNumbers(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "PhoneNumbers")) {
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Entry".equals(tagLocalName = reader.getLocalName())) continue;
            String key = this.getAttributeValue(reader, "Key");
            String value = XMLStreamUtil.getElementText(reader);
            responseItem.put(key, value);
        }
    }

    @Override
    protected void handleEmailAddresses(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "EmailAddresses")) {
            String value;
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Entry".equals(tagLocalName = reader.getLocalName()) || (value = XMLStreamUtil.getElementText(reader)) == null || !value.startsWith("smtp:") && !value.startsWith("SMTP:")) continue;
            value = value.substring(5);
            responseItem.putIfAbsent("EmailAddress", value);
        }
    }
}

