/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeNode;
import org.javacc.jjtree.Token;
import org.javacc.parser.JavaCCErrors;

public final class TokenUtils {
    private TokenUtils() {
    }

    static void print(Token t, IO io, String in, String out) {
        Token tt = t.specialToken;
        if (tt != null) {
            while (tt.specialToken != null) {
                tt = tt.specialToken;
            }
            while (tt != null) {
                io.print(TokenUtils.addUnicodeEscapes(tt.image));
                tt = tt.next;
            }
        }
        String i = t.image;
        if (in != null && i.equals(in)) {
            i = out;
        }
        io.print(TokenUtils.addUnicodeEscapes(i));
    }

    static void print(Token t, IO io) {
        TokenUtils.print(t, io, null, null);
    }

    static String addUnicodeEscapes(String str) {
        StringBuffer buff = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ((ch < ' ' || ch > '~') && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') {
                String s = "0000" + Integer.toString(ch, 16);
                buff.append("\\u" + s.substring(s.length() - 4, s.length()));
                continue;
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    static boolean hasTokens(JJTreeNode n) {
        return n.getLastToken().next != n.getFirstToken();
    }

    static String remove_escapes_and_quotes(Token t, String str) {
        String retval = "";
        int index = 1;
        while (index < str.length() - 1) {
            int ordinal;
            char ch;
            if (str.charAt(index) != '\\') {
                retval = retval + str.charAt(index);
                ++index;
                continue;
            }
            if ((ch = str.charAt(++index)) == 'b') {
                retval = retval + '\b';
                ++index;
                continue;
            }
            if (ch == 't') {
                retval = retval + '\t';
                ++index;
                continue;
            }
            if (ch == 'n') {
                retval = retval + '\n';
                ++index;
                continue;
            }
            if (ch == 'f') {
                retval = retval + '\f';
                ++index;
                continue;
            }
            if (ch == 'r') {
                retval = retval + '\r';
                ++index;
                continue;
            }
            if (ch == '\"') {
                retval = retval + '\"';
                ++index;
                continue;
            }
            if (ch == '\'') {
                retval = retval + '\'';
                ++index;
                continue;
            }
            if (ch == '\\') {
                retval = retval + '\\';
                ++index;
                continue;
            }
            if (ch >= '0' && ch <= '7') {
                char ch1;
                ordinal = ch - 48;
                if ((ch1 = str.charAt(++index)) >= '0' && ch1 <= '7') {
                    ordinal = ordinal * 8 + ch1 - 48;
                    ch1 = str.charAt(++index);
                    if (ch <= '3' && ch1 >= '0' && ch1 <= '7') {
                        ordinal = ordinal * 8 + ch1 - 48;
                        ++index;
                    }
                }
                retval = retval + (char)ordinal;
                continue;
            }
            if (ch == 'u') {
                if (TokenUtils.hexchar(ch = str.charAt(++index))) {
                    ordinal = TokenUtils.hexval(ch);
                    if (TokenUtils.hexchar(ch = str.charAt(++index))) {
                        ordinal = ordinal * 16 + TokenUtils.hexval(ch);
                        if (TokenUtils.hexchar(ch = str.charAt(++index))) {
                            ordinal = ordinal * 16 + TokenUtils.hexval(ch);
                            if (TokenUtils.hexchar(ch = str.charAt(++index))) {
                                ordinal = ordinal * 16 + TokenUtils.hexval(ch);
                                ++index;
                                continue;
                            }
                        }
                    }
                }
                JavaCCErrors.parse_error(t, "Encountered non-hex character '" + ch + "' at position " + index + " of string - Unicode escape must have 4 hex digits after it.");
                return retval;
            }
            JavaCCErrors.parse_error(t, "Illegal escape sequence '\\" + ch + "' at position " + index + " of string.");
            return retval;
        }
        return retval;
    }

    private static boolean hexchar(char ch) {
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if (ch >= 'A' && ch <= 'F') {
            return true;
        }
        return ch >= 'a' && ch <= 'f';
    }

    private static int hexval(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        return ch - 97 + 10;
    }
}

