/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import java.lang.reflect.Method;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.ObjectMarshaller;
import org.grails.web.json.JSONWriter;
import org.springframework.beans.BeanUtils;

public class EnumMarshaller
implements ObjectMarshaller<JSON> {
    @Override
    public boolean supports(Object object) {
        return object.getClass().isEnum();
    }

    @Override
    public void marshalObject(Object en, JSON json) throws ConverterException {
        JSONWriter writer = json.getWriter();
        try {
            writer.object();
            Class<?> enumClass = en.getClass();
            json.property("enumType", enumClass.getName());
            Method nameMethod = BeanUtils.findDeclaredMethod(enumClass, (String)"name", null);
            try {
                json.property("name", nameMethod.invoke(en, new Object[0]));
            }
            catch (Exception e) {
                json.property("name", "");
            }
            writer.endObject();
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Enum with class " + en.getClass().getName(), e);
        }
    }
}

