/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collections;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class SamWrapperCodegen {
    private final GenerationState state;
    private final boolean isInsideInline;
    private final KotlinTypeMapper typeMapper;
    private final SamType samType;
    private final MemberCodegen<?> parentCodegen;
    private final int visibility;
    public static final String SAM_WRAPPER_SUFFIX = "$0";

    public SamWrapperCodegen(@NotNull GenerationState state2, @NotNull SamType samType, @NotNull MemberCodegen<?> parentCodegen, boolean isInsideInline) {
        if (state2 == null) {
            SamWrapperCodegen.$$$reportNull$$$0(0);
        }
        if (samType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(1);
        }
        if (parentCodegen == null) {
            SamWrapperCodegen.$$$reportNull$$$0(2);
        }
        this.state = state2;
        this.isInsideInline = isInsideInline;
        this.typeMapper = state2.getTypeMapper();
        this.samType = samType;
        this.parentCodegen = parentCodegen;
        this.visibility = isInsideInline ? 1 : 0;
    }

    @NotNull
    public Type genWrapper(@NotNull KtFile file2, @NotNull CallableMemberDescriptor contextDescriptor) {
        if (file2 == null) {
            SamWrapperCodegen.$$$reportNull$$$0(3);
        }
        if (contextDescriptor == null) {
            SamWrapperCodegen.$$$reportNull$$$0(4);
        }
        FqName fqName2 = this.getWrapperName(file2, contextDescriptor);
        Type asmType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fqName2);
        KotlinType functionType = this.samType.getKotlinFunctionType();
        ClassDescriptorImpl classDescriptor2 = new ClassDescriptorImpl(this.samType.getJavaClassDescriptor().getContainingDeclaration(), fqName2.shortName(), Modality.FINAL, ClassKind.CLASS, Collections.singleton(this.samType.getType()), SourceElement.NO_SOURCE, false, LockBasedStorageManager.NO_LOCKS);
        SimpleFunctionDescriptor erasedInterfaceFunction = this.samType.getOriginalAbstractMethod().copy(classDescriptor2, Modality.FINAL, Visibilities.PUBLIC, CallableMemberDescriptor.Kind.SYNTHESIZED, false);
        ClassBuilder cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(erasedInterfaceFunction), asmType, file2);
        cv.defineClass(file2, this.state.getClassFileVersion(), 0x30 | this.visibility, asmType.getInternalName(), null, AsmTypes.OBJECT_TYPE.getInternalName(), new String[]{this.typeMapper.mapType(this.samType.getType()).getInternalName()});
        cv.visitSource(file2.getName(), null);
        WriteAnnotationUtilKt.writeSyntheticClassMetadata(cv, this.state);
        Type functionAsmType = this.typeMapper.mapType(functionType);
        cv.newField(JvmDeclarationOriginKt.OtherOrigin(erasedInterfaceFunction), 4114, "function", functionAsmType.getDescriptor(), null, null);
        this.generateConstructor(asmType, functionAsmType, cv);
        this.generateMethod(asmType, functionAsmType, cv, erasedInterfaceFunction, functionType);
        cv.done();
        Type type2 = asmType;
        if (type2 == null) {
            SamWrapperCodegen.$$$reportNull$$$0(5);
        }
        return type2;
    }

    private void generateConstructor(Type ownerType, Type functionType, ClassBuilder cv) {
        MethodVisitor mv = cv.newMethod(JvmDeclarationOriginKt.OtherOrigin(this.samType.getJavaClassDescriptor()), this.visibility, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), null, null);
        if (this.state.getClassBuilderMode().generateBodies) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.invokespecial(AsmTypes.OBJECT_TYPE.getInternalName(), "<init>", "()V", false);
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.load(1, functionType);
            iv.putfield(ownerType.getInternalName(), "function", functionType.getDescriptor());
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor of SAM wrapper");
        }
    }

    private void generateMethod(Type ownerType, Type functionType, ClassBuilder cv, SimpleFunctionDescriptor erasedInterfaceFunction, KotlinType functionJetType) {
        FunctionCodegen codegen2 = new FunctionCodegen(this.state.getRootContext().intoClass((ClassDescriptor)erasedInterfaceFunction.getContainingDeclaration(), OwnerKind.IMPLEMENTATION, this.state), cv, this.state, this.parentCodegen);
        SimpleFunctionDescriptor invokeFunction = functionJetType.getMemberScope().getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.FROM_BACKEND).iterator().next().getOriginal();
        StackValue.Field functionField = StackValue.field(functionType, ownerType, "function", false, StackValue.none());
        codegen2.genSamDelegate(erasedInterfaceFunction, invokeFunction, functionField);
        SimpleFunctionDescriptor originalInterfaceErased = this.samType.getOriginalAbstractMethod();
        ClosureCodegen.generateBridgesForSAM(originalInterfaceErased, erasedInterfaceFunction, codegen2);
    }

    @NotNull
    private FqName getWrapperName(@NotNull KtFile containingFile, CallableMemberDescriptor contextDescriptor) {
        FqName outermostOwner;
        if (containingFile == null) {
            SamWrapperCodegen.$$$reportNull$$$0(6);
        }
        boolean hasPackagePartClass = !CodegenUtil.getMemberDeclarationsToGenerate(containingFile).isEmpty();
        FqName filePartFqName = JvmFileClassUtil.getFileClassInfoNoResolve(containingFile).getFileClassFqName();
        if (hasPackagePartClass) {
            outermostOwner = filePartFqName;
        } else {
            ClassDescriptor outermostClassifier = SamWrapperCodegen.getOutermostParentClass(contextDescriptor);
            if (outermostClassifier == null) {
                throw new IllegalStateException("Can't find outermost parent class for " + contextDescriptor);
            }
            String internalName = this.typeMapper.mapType(outermostClassifier).getInternalName();
            outermostOwner = filePartFqName.parent().child(Name.identifier(StringsKt.substringAfterLast((String)internalName, (char)'/', (String)internalName)));
        }
        String shortName = String.format("%s$sam%s$%s$0", outermostOwner.shortName().asString(), this.isInsideInline ? "$i" : "", DescriptorUtils.getFqNameSafe(this.samType.getJavaClassDescriptor()).asString().replace('.', '_'));
        FqName fqName2 = outermostOwner.parent().child(Name.identifier(shortName));
        if (fqName2 == null) {
            SamWrapperCodegen.$$$reportNull$$$0(7);
        }
        return fqName2;
    }

    private static ClassDescriptor getOutermostParentClass(CallableMemberDescriptor contextDescriptor) {
        ClassDescriptor next;
        ClassDescriptor parent2 = DescriptorUtils.getParentOfType(contextDescriptor, ClassDescriptor.class, true);
        do {
            if ((next = DescriptorUtils.getParentOfType(parent2, ClassDescriptor.class, true)) == null) continue;
            parent2 = next;
        } while (next != null);
        return parent2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCodegen";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDescriptor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/SamWrapperCodegen";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/SamWrapperCodegen";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "genWrapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "genWrapper";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getWrapperName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

