/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class PairLayout
implements LayoutManager {
    private static final int MINIMUM_RIGHT_COLUMN_WIDTH = 80;
    private int vgap;
    private int hgap;
    private int preferredRightColumnWidth;
    private int leftColumnWidth;
    private int rowHeight;

    public PairLayout() {
        this(0, 0, 80);
    }

    public PairLayout(int vgap, int hgap) {
        this(vgap, hgap, 80);
    }

    public PairLayout(int vgap, int hgap, int minimumRightColumnWidth) {
        this.vgap = vgap;
        this.hgap = hgap;
        this.preferredRightColumnWidth = minimumRightColumnWidth;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.computeSizes(parent);
        int rowCount = (parent.getComponentCount() + 1) / 2;
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(0, 0);
        d.width = this.leftColumnWidth + this.hgap + this.preferredRightColumnWidth + insets.left + insets.right;
        d.height = this.rowHeight * rowCount + this.vgap * (rowCount - 1) + insets.top + insets.bottom;
        return d;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.computeSizes(parent);
        int rowCount = (parent.getComponentCount() + 1) / 2;
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(0, 0);
        d.width = this.leftColumnWidth + this.hgap + insets.left + insets.right;
        d.height = this.rowHeight * rowCount + this.vgap * (rowCount - 1) + insets.top + insets.bottom;
        return d;
    }

    @Override
    public void layoutContainer(Container parent) {
        this.computeSizes(parent);
        int componentCount = parent.getComponentCount();
        int rowCount = (componentCount + 1) / 2;
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int width = d.width - (insets.left + insets.right);
        int x = insets.left;
        int y = insets.top;
        int rightColumnWidth = width - (this.leftColumnWidth + this.hgap);
        for (int i = 0; i < rowCount; ++i) {
            Component leftColumnComponent = parent.getComponent(i * 2);
            leftColumnComponent.setBounds(x, y, this.leftColumnWidth, this.rowHeight);
            if (componentCount <= i * 2 + 1) continue;
            Component rightColumnComponent = parent.getComponent(i * 2 + 1);
            rightColumnComponent.setBounds(x + this.leftColumnWidth + this.hgap, y, rightColumnWidth, this.rowHeight);
            y += this.rowHeight + this.vgap;
        }
    }

    private void computeSizes(Container parent) {
        int componentCount = parent.getComponentCount();
        int rowCount = (componentCount + 1) / 2;
        this.leftColumnWidth = 0;
        this.rowHeight = 0;
        for (int i = 0; i < rowCount; ++i) {
            Component leftColumnComponent = parent.getComponent(i * 2);
            Dimension d = leftColumnComponent.getPreferredSize();
            this.leftColumnWidth = Math.max(this.leftColumnWidth, d.width);
            this.rowHeight = Math.max(this.rowHeight, d.height);
            if (componentCount <= i * 2 + 1) continue;
            Component rightColumnComponent = parent.getComponent(i * 2 + 1);
            d = rightColumnComponent.getPreferredSize();
            this.rowHeight = Math.max(this.rowHeight, d.height);
            this.preferredRightColumnWidth = Math.max(this.preferredRightColumnWidth, d.width);
        }
    }
}

