/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.vdex.DexSectionHeader_002;
import ghidra.file.formats.android.vdex.VdexStringTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class VdexHeader
implements StructConverter {
    protected String magic_;
    protected String verifier_deps_version_;
    protected VdexStringTable stringTable;
    protected List<Long> dexHeaderStartsList = new ArrayList<Long>();
    protected List<DexHeader> dexHeaderList = new ArrayList<DexHeader>();

    protected VdexHeader(BinaryReader reader) throws IOException {
        this.magic_ = new String(reader.readNextByteArray("vdex".length()));
    }

    public final String getMagic() {
        return this.magic_;
    }

    public final String getVerifierDepsVersion() {
        return this.verifier_deps_version_;
    }

    public abstract void parse(BinaryReader var1, TaskMonitor var2) throws IOException, CancelledException;

    public final long getDexStartOffset(int index) {
        return this.dexHeaderStartsList.get(index);
    }

    public abstract int getVerifierDepsSize();

    public abstract int getQuickeningInfoSize();

    public abstract int[] getDexChecksums();

    public final List<DexHeader> getDexHeaderList() {
        return this.dexHeaderList;
    }

    public final VdexStringTable getStringTable() {
        return this.stringTable;
    }

    public abstract boolean isDexHeaderEmbeddedInDataType();

    public abstract DexSectionHeader_002 getDexSectionHeader_002();
}

