/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.file.formats.android.dex.format.EncodedValue;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;

public class EncodedArray
implements StructConverter {
    private int size;
    private int sizeLength;
    private byte[] values;

    public EncodedArray(BinaryReader reader) throws IOException {
        LEB128 leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.size = leb128.asUInt32();
        this.sizeLength = leb128.getLength();
        BinaryReader evReader = reader.clone();
        ArrayList<EncodedValue> valuesList = new ArrayList<EncodedValue>();
        for (int i = 0; i < this.size; ++i) {
            valuesList.add(new EncodedValue(evReader));
        }
        int nBytes = (int)(evReader.getPointerIndex() - reader.getPointerIndex());
        this.values = reader.readNextByteArray(nBytes);
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getValues() {
        return this.values;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("encoded_array_" + this.values.length, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.sizeLength, BYTE.getLength()), "size", null);
        if (this.values.length > 0) {
            structure.add((DataType)new ArrayDataType(BYTE, this.values.length, BYTE.getLength()), "values", null);
        }
        structure.setCategoryPath(new CategoryPath("/dex/encoded_array"));
        return structure;
    }
}

