/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.debughost;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.debughost.DebugHostContext;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostEvaluatorInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectImpl;
import agent.dbgmodel.jna.dbgmodel.debughost.IDebugHostEvaluator1;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.PointerByReference;

public class DebugHostEvaluatorImpl1
implements DebugHostEvaluatorInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDebugHostEvaluator1 jnaData;

    public DebugHostEvaluatorImpl1(IDebugHostEvaluator1 jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public ModelObject evaluateExpression(DebugHostContext context, WString expression, ModelObject bindingContext) {
        Pointer pContext = context.getPointer();
        Pointer pBindingContext = bindingContext.getPointer();
        PointerByReference ppResult = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        this.jnaData.EvaluateExpression(pContext, expression, pBindingContext, ppResult, ppMetadata);
        return ModelObjectImpl.getObjectWithMetadata(ppResult, ppMetadata);
    }

    @Override
    public ModelObject evaluateExtendedExpression(DebugHostContext context, WString expression, ModelObject bindingContext) {
        Pointer pContext = context.getPointer();
        Pointer pBindingContext = bindingContext.getPointer();
        PointerByReference ppResult = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        this.jnaData.EvaluateExtendedExpression(pContext, expression, pBindingContext, ppResult, ppMetadata);
        return ModelObjectImpl.getObjectWithMetadata(ppResult, ppMetadata);
    }
}

