/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.DialogComponentProvider;
import docking.options.editor.OptionsEditorListener;
import docking.options.editor.OptionsPanel;
import docking.widgets.OptionDialog;
import ghidra.framework.options.Options;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.tree.TreePath;

public class OptionsDialog
extends DialogComponentProvider {
    private OptionsPanel panel;
    private boolean hasChanges;
    private OptionsEditorListener listener;

    public OptionsDialog(String title, String rootNodeName, Options[] options, OptionsEditorListener listener) {
        this(title, rootNodeName, options, listener, false);
    }

    public OptionsDialog(String title, String rootNodeName, Options[] options, OptionsEditorListener listener, boolean showRestoreDefaultsButton) {
        super("OptionsDialog.Foofoo", true, false, true, false);
        this.listener = listener;
        this.panel = new OptionsPanel(rootNodeName, options, showRestoreDefaultsButton, new OptionsPropertyChangeListener());
        this.setTitle(title);
        this.setBackground(Color.lightGray);
        this.addWorkPanel(this.panel);
        this.addOKButton();
        this.addCancelButton();
        this.addApplyButton();
        this.setApplyEnabled(false);
        this.setMinimumSize(1000, 600);
        this.setFocusComponent(this.panel.getFocusComponent());
    }

    @Override
    public void dispose() {
        this.panel.dispose();
    }

    public TreePath getSelectedPath() {
        return this.panel.getSelectedPath();
    }

    public void setSelectedPath(TreePath path) {
        this.panel.setSelectedPath(path);
    }

    private void setHasChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
        this.setApplyEnabled(hasChanges);
    }

    @Override
    protected void cancelCallback() {
        this.panel.cancel();
        if (this.hasChanges) {
            int result = OptionDialog.showYesNoCancelDialog(this.panel, "Save Changes?", "These options have changed.  Do you want to save them?");
            if (result == 0) {
                return;
            }
            if (result == 1) {
                this.applyChanges();
            }
        }
        this.close();
    }

    @Override
    protected void okCallback() {
        if (this.hasChanges && !this.applyChanges()) {
            return;
        }
        this.close();
    }

    @Override
    protected void applyCallback() {
        this.applyChanges();
    }

    private boolean applyChanges() {
        if (this.listener != null) {
            this.listener.beforeChangesApplied();
        }
        try {
            if (this.panel.apply()) {
                this.setHasChanges(false);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (this.listener != null) {
                this.listener.changesApplied();
            }
        }
        return false;
    }

    public void displayCategory(String category, String filterText) {
        if (this.panel != null) {
            this.panel.displayCategory(category, filterText);
        }
    }

    class OptionsPropertyChangeListener
    implements PropertyChangeListener {
        OptionsPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("apply.enabled")) {
                OptionsDialog.this.setHasChanges((Boolean)evt.getNewValue());
            }
        }
    }
}

