/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingContextListener;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.actions.DockingToolActions;
import docking.actions.PopupActionProvider;
import docking.actions.ToolActions;
import ghidra.framework.options.ToolOptions;
import ghidra.util.Swing;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;

public abstract class AbstractDockingTool
implements Tool {
    protected DockingWindowManager winMgr;
    protected ToolActions toolActions;
    protected Map<String, ToolOptions> optionsMap = new HashMap<String, ToolOptions>();
    protected boolean configChangedFlag;

    @Override
    public boolean isVisible() {
        return this.winMgr.isVisible();
    }

    @Override
    public void setVisible(boolean visibility) {
        this.winMgr.setVisible(visibility);
    }

    @Override
    public void toFront() {
        JFrame frame = this.winMgr.getRootFrame();
        if (frame.getExtendedState() == 1) {
            frame.setExtendedState(0);
        }
        frame.toFront();
    }

    @Override
    public void addComponentProvider(ComponentProvider provider, boolean show) {
        Runnable r = () -> {
            this.winMgr.addComponent(provider, show);
            this.toolActions.addGlobalAction(provider.getShowProviderAction());
        };
        Swing.runNow((Runnable)r);
    }

    @Override
    public void removeComponentProvider(ComponentProvider provider) {
        Runnable r = () -> {
            this.toolActions.removeGlobalAction(provider.getShowProviderAction());
            this.toolActions.removeActions(provider);
            this.winMgr.removeComponent(provider);
        };
        Swing.runNow((Runnable)r);
    }

    @Override
    public ComponentProvider getComponentProvider(String name) {
        return this.winMgr.getComponentProvider(name);
    }

    @Override
    public void setStatusInfo(String text) {
        this.winMgr.setStatusText(text);
    }

    @Override
    public void setStatusInfo(String text, boolean beep) {
        this.winMgr.setStatusText(text);
        if (beep) {
            Toolkit tk = this.getToolFrame().getToolkit();
            tk.beep();
        }
    }

    @Override
    public void clearStatusInfo() {
        this.winMgr.setStatusText("");
    }

    @Override
    public void addAction(DockingActionIf action) {
        this.toolActions.addGlobalAction(action);
    }

    @Override
    public void removeAction(DockingActionIf action) {
        this.toolActions.removeGlobalAction(action);
    }

    @Override
    public void addLocalAction(ComponentProvider provider, DockingActionIf action) {
        this.toolActions.addLocalAction(provider, action);
    }

    @Override
    public void removeLocalAction(ComponentProvider provider, DockingActionIf action) {
        this.toolActions.removeLocalAction(provider, action);
    }

    @Override
    public Set<DockingActionIf> getAllActions() {
        return this.toolActions.getAllActions();
    }

    @Override
    public void addPopupActionProvider(PopupActionProvider provider) {
        this.winMgr.addPopupActionProvider(provider);
    }

    @Override
    public void removePopupActionProvider(PopupActionProvider provider) {
        this.winMgr.removePopupActionProvider(provider);
    }

    @Override
    public Set<DockingActionIf> getDockingActionsByOwnerName(String owner) {
        return this.toolActions.getActions(owner);
    }

    @Override
    public ComponentProvider getActiveComponentProvider() {
        return this.winMgr.getActiveComponentProvider();
    }

    @Override
    public void showComponentProvider(ComponentProvider provider, boolean visible) {
        Runnable r = () -> this.winMgr.showComponent(provider, visible);
        Swing.runNow((Runnable)r);
    }

    @Override
    public void showDialog(DialogComponentProvider dialogComponent) {
        DockingWindowManager.showDialog(null, dialogComponent);
    }

    public JFrame getToolFrame() {
        return this.winMgr.getRootFrame();
    }

    @Override
    public Window getProviderWindow(ComponentProvider provider) {
        return this.winMgr.getProviderWindow(provider);
    }

    @Override
    public void toFront(ComponentProvider provider) {
        Runnable r = () -> this.winMgr.toFront(provider);
        Swing.runNow((Runnable)r);
    }

    @Override
    public boolean isVisible(ComponentProvider provider) {
        return this.winMgr.isVisible(provider);
    }

    @Override
    public boolean isActive(ComponentProvider provider) {
        return this.winMgr.isActiveProvider(provider);
    }

    @Override
    public void updateTitle(ComponentProvider provider) {
        this.winMgr.updateTitle(provider);
    }

    public void setMenuGroup(String[] menuPath, String group) {
        this.setMenuGroup(menuPath, group, null);
    }

    @Override
    public void setMenuGroup(String[] menuPath, String group, String menuSubGroup) {
        this.winMgr.setMenuGroup(menuPath, group, menuSubGroup);
    }

    @Override
    public void contextChanged(ComponentProvider provider) {
        this.winMgr.contextChanged(provider);
    }

    @Override
    public void addContextListener(DockingContextListener listener) {
        this.winMgr.addContextListener(listener);
    }

    @Override
    public void removeContextListener(DockingContextListener listener) {
        this.winMgr.removeContextListener(listener);
    }

    @Override
    public DockingWindowManager getWindowManager() {
        return this.winMgr;
    }

    @Override
    public void setConfigChanged(boolean changed) {
        this.configChangedFlag = changed;
    }

    @Override
    public boolean hasConfigChanged() {
        return this.configChangedFlag;
    }

    @Override
    public DockingToolActions getToolActions() {
        return this.toolActions;
    }
}

