/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.wrapper;

import com.sun.jna.PlatformEx;
import io.netty.util.internal.logging.SimpleLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.rzo.yajsw.boot.WrapperServiceBooter;
import org.rzo.yajsw.cache.Cache;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Service;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPService;
import org.rzo.yajsw.os.posix.PosixService;
import org.rzo.yajsw.util.Utils;

public class WrappedService {
    YajswConfigurationImpl _config;
    int _debug = 3;
    static final String PATHSEP = System.getProperty("path.separator");
    Logger _log = Logger.getLogger(this.getClass().getName());
    protected Configuration _localConfiguration = new BaseConfiguration();
    boolean _useSystemProperties = true;
    Service _osService;
    Cache _cache = null;
    volatile boolean _init = false;
    private List<String> _confFilesList;

    public void init() {
        int umask;
        if (this._init) {
            return;
        }
        HashMap<String, Utils> utils = new HashMap<String, Utils>();
        utils.put("util", new Utils(this));
        if (this._confFilesList != null && !this._confFilesList.isEmpty() && this._localConfiguration != null && !this._localConfiguration.containsKey("wrapper.config")) {
            this._localConfiguration.setProperty("wrapper.config", (Object)this._confFilesList.get(0));
        }
        this._config = new YajswConfigurationImpl(this._localConfiguration, this._useSystemProperties, utils);
        if (this._confFilesList != null && !this._confFilesList.isEmpty()) {
            this._config.setProperty("wrapperx.config", this._confFilesList);
        }
        if ((umask = Utils.parseOctal(this._config.getString("wrapper.umask", null))) != -1) {
            OperatingSystem.instance().processManagerInstance().umask(umask);
        }
        if (!this._config.isLocalFile() && this._cache == null) {
            this._cache = new Cache();
            this._cache.load(this._config);
        }
        this._debug = this._config.getBoolean("wrapper.debug", false) ? this._config.getInt("wrapper.debug.level", 3) : 0;
        this._osService = OperatingSystem.instance().serviceManagerInstance().createService();
        this._osService.setLogger(this._log);
        this._osService.setName(this._config.getString("wrapper.ntservice.name"));
        String displayName = this._config.getString("wrapper.ntservice.displayname");
        String description = this._config.getString("wrapper.ntservice.description");
        HashSet<String> dependeciesSet = new HashSet<String>();
        Iterator it = this._config.getKeys("wrapper.ntservice.dependency");
        while (it.hasNext()) {
            String value = this._config.getString((String)it.next());
            if (value == null || value.length() <= 0) continue;
            dependeciesSet.add(value);
        }
        String[] dependencies = new String[dependeciesSet.size()];
        int i = 0;
        Iterator it2 = dependeciesSet.iterator();
        while (it2.hasNext()) {
            dependencies[i] = (String)it2.next();
            ++i;
        }
        dependeciesSet = new HashSet();
        it2 = this._config.getKeys("wrapper.ntservice.stop_dependency");
        while (it2.hasNext()) {
            String value = this._config.getString((String)it2.next());
            if (value == null || value.length() <= 0) continue;
            dependeciesSet.add(value);
        }
        String[] stopDependencies = new String[dependeciesSet.size()];
        i = 0;
        Iterator it3 = dependeciesSet.iterator();
        while (it3.hasNext()) {
            stopDependencies[i] = (String)it3.next();
            ++i;
        }
        String account = this._config.getString("wrapper.ntservice.account");
        String password = this._config.getString("wrapper.ntservice.password");
        String startType = this._config.getString("wrapper.ntservice.starttype", "AUTO_START");
        String[] command = this.getCommand();
        this._osService.setAccount(account);
        this._osService.setCommand(command);
        this._osService.setDependencies(dependencies);
        this._osService.setStopDependencies(dependencies);
        this._osService.setDescription(description);
        this._osService.setDisplayName(displayName);
        this._osService.setPassword(password);
        this._osService.setConfig((Configuration)this._config);
        this._osService.setStartType(startType);
        this._osService.setFailureActions(OperatingSystem.instance().getServiceFailureActions((Configuration)this._config));
        this._osService.init();
        this._init = true;
    }

    public boolean install() {
        boolean i = false;
        return this._osService.install();
    }

    public boolean uninstall() {
        if (this._osService == null) {
            return false;
        }
        this.stop();
        return this._osService.uninstall();
    }

    protected void addClasspathFromManifest(ArrayList classpath, File f) {
        try {
            Manifest manifest = new JarFile(f).getManifest();
            Attributes attr = manifest.getMainAttributes();
            String cl = attr.getValue("Class-Path");
            if (cl == null) {
                return;
            }
            String[] clArr = cl.split(" ");
            for (int i = 0; i < clArr.length; ++i) {
                String file = clArr[i];
                File myFile = new File(f.getParent(), file).getCanonicalFile();
                if (myFile.exists() && !classpath.contains(myFile)) {
                    classpath.add(myFile);
                    continue;
                }
                if (myFile.exists()) continue;
                System.out.println("file not found " + myFile);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected ArrayList wrapperOptions() {
        String tmpDir;
        int additionalCount = 1;
        boolean xrsFound = false;
        ArrayList<String> result = new ArrayList<String>();
        if (this._config.getBoolean("wrapper.save_interpolated", true)) {
            for (Map.Entry<String, String> e : this._config.getEnvLookupSet().entrySet()) {
                if (e.getKey().contains("password")) continue;
                result.add(Utils.getDOption(e.getKey(), e.getValue()));
            }
            for (String key : this._config.getLookupSet()) {
                if (key.contains("password") || "wrapper.working.dir".equals(key)) continue;
                result.add(Utils.getDOption(key, this._config.getString(key)));
            }
        }
        Iterator it = this._config.getSystemConfiguration().getKeys("wrapper");
        while (it.hasNext()) {
            String key;
            key = (String)it.next();
            if (key.equals("wrapper.config")) {
                result.add(Utils.getDOption(key, this._config.getCachedPath()));
            } else {
                result.add(Utils.getDOption(key, this._config.getString(key)));
            }
            if (!key.startsWith("wrapper.additional.")) continue;
            ++additionalCount;
            if (!this._config.getString(key).equals("-Xrs")) continue;
            xrsFound = true;
        }
        if (this._confFilesList != null && this._confFilesList.size() > 1) {
            String confList = "";
            for (int i = 0; i < this._confFilesList.size(); ++i) {
                Configuration localConfiguration = ConfigurationUtils.cloneConfiguration((Configuration)this._localConfiguration);
                String conf = this._confFilesList.get(i);
                localConfiguration.setProperty("wrapper.config", (Object)conf);
                HashMap<String, Utils> utils = new HashMap<String, Utils>();
                utils.put("util", new Utils(this));
                YajswConfigurationImpl config = new YajswConfigurationImpl(localConfiguration, this._useSystemProperties, utils);
                Cache cache = null;
                if (!config.isLocalFile()) {
                    cache = new Cache();
                    cache.load(config);
                }
                confList = confList + config.getCachedPath();
                if (i >= this._confFilesList.size() - 1) continue;
                confList = confList + ",";
            }
            result.add(Utils.getDOption("wrapperx.config", confList));
        }
        if (!xrsFound) {
            result.add("-Dwrapper.additional." + additionalCount + "x=-Xrs");
        }
        if (this._config.getString("wrapper.stop.conf") != null) {
            try {
                result.add(Utils.getDOption("wrapper.stop.conf", new File(this._config.getString("wrapper.stop.conf")).getCanonicalPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._config.getString("wrapper.groovy") != null) {
            try {
                result.add(Utils.getDOption("wrapper.groovy", new File(this._config.getString("wrapper.groovy")).getCanonicalPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((tmpDir = this._config.getString("wrapper.tmp.path", null)) == null) {
            tmpDir = System.getProperty("java.io.tmpdir");
        }
        File tmpFile = new File(tmpDir);
        result.add(Utils.getDOption("jna_tmpdir", tmpFile.getAbsolutePath()));
        return result;
    }

    public Configuration getLocalConfiguration() {
        return this._localConfiguration;
    }

    public void setLocalConfiguration(Configuration config) {
        this._localConfiguration = config;
    }

    public boolean isInstalled() {
        if (this._osService != null) {
            return this._osService.isInstalled(this.state());
        }
        return false;
    }

    public boolean isRunning() {
        if (this._osService != null) {
            return this._osService.isRunning(this.state());
        }
        return false;
    }

    public boolean isStarting() {
        if (this._osService != null) {
            return this._osService.isStarting(this.state());
        }
        return false;
    }

    public void setUseSystemProperties(boolean useSystem) {
        this._useSystemProperties = useSystem;
    }

    public boolean start() {
        if (this._osService != null) {
            return this._osService.start();
        }
        return false;
    }

    public boolean stop() {
        if (this._osService != null) {
            return this._osService.stop();
        }
        return false;
    }

    String[] getCommand() {
        File wd;
        Iterator it = this._config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith("wrapper.")) continue;
            try {
                this._config.getList(key);
            }
            catch (Exception exception) {}
        }
        JavaHome javaHome = OperatingSystem.instance().getJavaHome((Configuration)this._config);
        javaHome.setLogger(SimpleLoggerFactory.getInstance(this.getClass().getName()), this._debug);
        String java = javaHome.findJava(this._config.getString("wrapper.ntservice.java.command", this._config.getString("wrapper.java.command")), this._config.getString("wrapper.ntservice.java.customProcName"));
        if (java == null) {
            this._log.warning("no java exe found. check configuration file. -> using default \"java\"");
            java = "java";
        }
        ArrayList jvmOptions = this.jvmOptions();
        ArrayList wrapperOptions = this.wrapperOptions();
        String mainClass = this.getServiceMainClass();
        String workingDir = this._config.getString("wrapper.working.dir");
        if (!(workingDir == null || (wd = new File(workingDir)).exists() && wd.isDirectory())) {
            this._log.warning("working directory " + workingDir + " not found");
        }
        String[] result = new String[jvmOptions.size() + wrapperOptions.size() + 2];
        result[0] = java;
        result[result.length - 1] = mainClass;
        int i = 1;
        ListIterator it2 = jvmOptions.listIterator();
        while (it2.hasNext()) {
            result[i] = (String)it2.next();
            ++i;
        }
        it2 = wrapperOptions.listIterator();
        while (it2.hasNext()) {
            result[i] = (String)it2.next();
            ++i;
        }
        return result;
    }

    private String getServiceMainClass() {
        return WrapperServiceBooter.class.getName();
    }

    private ArrayList jvmOptions() {
        File f;
        ArrayList<String> result = new ArrayList<String>();
        result.add("-classpath");
        ArrayList<File> classpath = new ArrayList<File>();
        String[] files = this._config.getString("java.class.path").split(PATHSEP);
        for (int i = 0; i < files.length; ++i) {
            File f2 = null;
            try {
                f2 = new File(files[i]).getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (f2 == null || !f2.exists() || classpath.contains(f2.getAbsolutePath())) continue;
            classpath.add(f2);
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = classpath.iterator();
        while (it.hasNext()) {
            String canonicalFileName = null;
            try {
                canonicalFileName = ((File)it.next()).getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sb.append(canonicalFileName);
            if (!it.hasNext()) continue;
            sb.append(PATHSEP);
        }
        String cp = sb.toString();
        if (cp.contains(" ")) {
            cp = "\"" + cp + "\"";
        }
        result.add(cp);
        result.add("-Xrs");
        result.add("-Dwrapper.service=true");
        String wDir = this._config.getString("wrapper.working.dir");
        if (wDir != null && (f = new File(wDir)).exists() && f.isDirectory()) {
            try {
                result.add(Utils.getDOption("wrapper.working.dir", f.getCanonicalPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._config.getBoolean("wrapper.ntservice.debug", false)) {
            result.add("-Xdebug");
            result.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=1044");
        }
        Iterator it2 = this._config.getKeys("wrapper.ntservice.additional");
        while (it2.hasNext()) {
            String key = (String)it2.next();
            String value = this._config.getString(key);
            result.add(value);
        }
        if (this.verifyNeedIPv4IsPreferred() && !result.contains("-Djava.net.preferIPv4Stack=true")) {
            result.add("-Djava.net.preferIPv4Stack=true");
            if (this._log != null) {
                this._log.info("Windows & JVM7: Setting -Djava.net.preferIPv4Stack=true (see java bug 7179799 )");
            }
        }
        return result;
    }

    private boolean verifyNeedIPv4IsPreferred() {
        boolean isJDK7 = System.getProperty("java.version").startsWith("1.7");
        boolean isWindows = PlatformEx.isWinVista();
        return isWindows && isJDK7;
    }

    public String getServiceName() {
        return this._config.getString("wrapper.ntservice.name");
    }

    public static void main(String[] args) {
        System.setProperty("wrapper.java.app.mainclass", "test.HelloWorld");
        System.setProperty("wrapper.ntservice.name", "JavaServiceWrapper_1207751158998");
        System.setProperty("wrapper.filter.trigger.1", "999");
        System.setProperty("wrapper.java.additional.1", "-Xrs");
        System.setProperty("wrapper.on_exit.default", "RESTART");
        WrappedService w = new WrappedService();
        System.out.println("init");
        w.init();
        System.out.println("install");
        w.install();
        for (int i = 0; i < 10; ++i) {
            System.out.println("start");
            w.start();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("stop");
            w.stop();
        }
        System.out.println("uninstall");
        w.uninstall();
    }

    public int state() {
        if (this._osService != null) {
            return this._osService.state();
        }
        return 128;
    }

    public boolean isInstalled(int state) {
        if (this._osService == null) {
            return false;
        }
        return this._osService.isInstalled(state);
    }

    public boolean isRunning(int state) {
        if (this._osService == null) {
            return false;
        }
        return this._osService.isRunning(state);
    }

    public boolean isInteractive(int state) {
        if (this._osService == null) {
            return false;
        }
        return this._osService.isInteractive(state);
    }

    public boolean isAutomatic(int state) {
        if (this._osService == null) {
            return false;
        }
        return this._osService.isAutomatic(state);
    }

    public boolean isManual(int state) {
        if (this._osService == null) {
            return false;
        }
        return this._osService.isManual(state);
    }

    public boolean isDisabled(int state) {
        if (this._osService == null) {
            return false;
        }
        return this._osService.isDisabled(state);
    }

    public boolean isPaused(int state) {
        if (this._osService == null) {
            return false;
        }
        return this._osService.isPaused(state);
    }

    public boolean isStateUnknown(int state) {
        if (this._osService == null) {
            return false;
        }
        return this._osService.isStateUnknown(state);
    }

    public void stopProcess() {
        if (this._osService instanceof PosixService) {
            ((PosixService)this._osService).stopProcess();
        } else {
            this.stop();
        }
    }

    public void startProcess() {
        if (this._osService instanceof PosixService) {
            ((PosixService)this._osService).startProcess();
        } else {
            this.start();
        }
    }

    public String getConfigLocalPath() {
        return this._config.getCachedPath(false);
    }

    public void setConfFilesList(List<String> confFiles) {
        this._confFilesList = confFiles;
    }

    public boolean requiresElevate() {
        if (this._osService != null && this._osService instanceof WindowsXPService) {
            return ((WindowsXPService)this._osService).requestElevation();
        }
        return false;
    }
}

