/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix;

import java.util.ArrayList;
import java.util.Iterator;
import org.rzo.yajsw.os.posix.PosixProcess;

public class PosixSpawnMain {
    public static void main(String[] args) {
        int umask;
        PosixProcess.CLibrary.INSTANCE.umask(0);
        PosixProcess.CLibrary.INSTANCE.setsid();
        int nice = PosixSpawnMain.getNice();
        if (nice != 0 && PosixProcess.CLibrary.INSTANCE.nice(nice) == -1) {
            System.out.println("could not set priority ");
        }
        if ((umask = PosixSpawnMain.getUmask()) != 0 && PosixProcess.CLibrary.INSTANCE.umask(umask) != 0) {
            System.out.println("could not set umask ");
        }
        if (PosixSpawnMain.getUser() != null) {
            try {
                new PosixProcess().switchUser(PosixSpawnMain.getUser(), PosixSpawnMain.getPassword());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (PosixSpawnMain.getWorkingdir() != null && PosixProcess.CLibrary.INSTANCE.chdir(PosixSpawnMain.getWorkingdir()) != 0) {
            System.out.println("could not set working dir");
        }
        String[] env = null;
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
        }
        int ret = -1;
        try {
            if (env == null) {
                PosixProcess.CLibrary.INSTANCE.execvp(args[0], args);
            } else {
                PosixProcess.CLibrary.INSTANCE.execvpe(args[0], args, env);
            }
            System.out.println("ret " + ret);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isPipeStreams() {
        return System.getProperty("wrapperx.pipeStreams") != null;
    }

    private static String getPassword() {
        return System.getProperty("wrapperx.password");
    }

    private static String getUser() {
        return System.getProperty("wrapperx.user");
    }

    private static String getWorkingdir() {
        return System.getProperty("wrapperx.workingdir");
    }

    private static int getNice() {
        String x = System.getProperty("wrapperx.nice", "0");
        return Integer.parseInt(x);
    }

    private static int getUmask() {
        String u = System.getProperty("wrapperx.umask", "0");
        return Integer.parseInt(u);
    }

    private static String[] getEnv() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : System.getenv().keySet()) {
            result.add(key + "=" + System.getenv(key));
        }
        if (result.isEmpty()) {
            return null;
        }
        String[] arr = new String[result.size()];
        int i = 0;
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            String x;
            arr[i] = x = (String)iterator.next();
            System.out.println(x);
            ++i;
        }
        return arr;
    }
}

