/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.LineNumber;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class LineNumberTableAttribute
extends AbstractAttributeInfo {
    private short lineNumberTableLength;
    private LineNumber[] lineNumberTable;

    public LineNumberTableAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.lineNumberTableLength = reader.readNextShort();
        this.lineNumberTable = new LineNumber[this.lineNumberTableLength & 0xFFFF];
        for (int i = 0; i < (this.lineNumberTableLength & 0xFFFF); ++i) {
            this.lineNumberTable[i] = new LineNumber(reader);
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "LineNumberTable_attribute|" + this.lineNumberTableLength + "|";
        StructureDataType structure = this.getBaseStructure(name);
        structure.add(WORD, "line_number_table_length", null);
        for (int i = 0; i < this.lineNumberTable.length; ++i) {
            structure.add(this.lineNumberTable[i].toDataType(), "line_number_" + i, null);
        }
        return structure;
    }
}

