/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.message;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.OutputProducer;
import org.rzo.netty.ahessian.io.OutputStreamHandler;
import org.rzo.netty.ahessian.rpc.io.Hessian2Output;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;

public class HessianRPCReplyEncoder
extends OutputProducer {
    volatile Hessian2Output hOut = null;
    volatile AbstractSerializerFactory _serializerFactory;

    public HessianRPCReplyEncoder(Executor executor) {
        this(null, executor);
    }

    public HessianRPCReplyEncoder(AbstractSerializerFactory serializerFactory, Executor executor) {
        super(executor);
        this._serializerFactory = serializerFactory;
    }

    @Override
    public synchronized void produceOutput(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (ctx == null || ctx.channel() == null || !ctx.channel().isActive()) {
            throw new RuntimeException("channel closed");
        }
        try {
            HessianRPCReplyMessage message = (HessianRPCReplyMessage)msg;
            this.hOut.resetReferences();
            this.hOut.writeReply(message);
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", (Throwable)ex);
            promise.setFailure((Throwable)ex);
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.hOut == null) {
            OutputStream out = OutputStreamHandler.getOutputStream(ctx);
            this.hOut = new Hessian2Output(out);
            if (this._serializerFactory != null) {
                this.hOut.getSerializerFactory().addFactory(this._serializerFactory);
            }
        } else {
            this.hOut.reset();
        }
        super.channelActive(ctx);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        super.connect(ctx, remoteAddress, localAddress, promise);
        if (this.hOut == null) {
            OutputStream out = OutputStreamHandler.getOutputStream(ctx);
            this.hOut = new Hessian2Output(out);
            if (this._serializerFactory != null) {
                this.hOut.getSerializerFactory().addFactory(this._serializerFactory);
            }
        } else {
            this.hOut.reset();
        }
        ctx.fireChannelActive();
    }

    @Override
    protected void flashOutput(ChannelHandlerContext ctx) throws Exception {
        if (!ctx.channel().isActive()) {
            throw new RuntimeException("channel not active");
        }
        this.hOut.flush();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelRegistered();
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelUnregistered();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ctx.fireChannelRead(msg);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireUserEventTriggered(evt);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelWritabilityChanged();
    }
}

