/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.StateType;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbStateListener;
import agent.lldb.model.AbstractLldbModel;
import agent.lldb.model.iface1.LldbModelTargetAccessConditioned;
import agent.lldb.model.iface1.LldbModelTargetExecutionStateful;
import agent.lldb.model.iface2.LldbModelTargetObject;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetSession;
import agent.lldb.model.iface2.LldbModelTargetThread;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetObjectSchema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class LldbModelTargetObjectImpl
extends DefaultTargetObject<TargetObject, TargetObject>
implements LldbModelTargetObject {
    protected boolean accessible = true;
    protected final LldbStateListener accessListener = this::checkExited;
    private boolean modified;
    private Object modelObject;
    protected Map<Object, TargetObject> objectMap = new HashMap<Object, TargetObject>();

    public LldbModelTargetObjectImpl(AbstractLldbModel impl, TargetObject parent, String name, String typeHint) {
        super((AbstractDebuggerObjectModel)impl, parent, name, typeHint);
        this.setModelObject(((LldbModelTargetObject)parent).getModelObject());
        this.getManager().addStateListener(this.accessListener);
    }

    public LldbModelTargetObjectImpl(AbstractLldbModel impl, TargetObject parent, String name, Object modelObject, String typeHint) {
        super((AbstractDebuggerObjectModel)impl, parent, name, typeHint);
        this.setModelObject(modelObject);
        this.getManager().addStateListener(this.accessListener);
    }

    public LldbModelTargetObjectImpl(AbstractLldbModel impl, TargetObject parent, String name, Object modelObject, String typeHint, TargetObjectSchema schema) {
        super((AbstractDebuggerObjectModel)impl, parent, name, typeHint, schema);
        this.setModelObject(modelObject);
        this.getManager().addStateListener(this.accessListener);
    }

    public void setAttribute(String key, String value) {
        this.changeAttributes(List.of(), List.of(), Map.of(key, value), "Initialized");
    }

    protected void doInvalidate(TargetObject branch, String reason) {
        super.doInvalidate(branch, reason);
        this.getManager().removeStateListener(this.accessListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessible(boolean accessible) {
        Map map = this.attributes;
        synchronized (map) {
            if (this.accessible == accessible) {
                return;
            }
            this.accessible = accessible;
        }
        if (this instanceof LldbModelTargetAccessConditioned) {
            this.changeAttributes(List.of(), List.of(), Map.of("_accessible", accessible), "Accessibility changed");
        }
    }

    @Override
    public AbstractLldbModel getModel() {
        return (AbstractLldbModel)this.model;
    }

    public void onRunning() {
        this.setAccessible(false);
    }

    public void onStopped() {
        this.setAccessible(true);
    }

    public void onExit() {
        this.setAccessible(true);
    }

    protected void checkExited(StateType state, LldbCause cause) {
        TargetExecutionStateful.TargetExecutionState exec = TargetExecutionStateful.TargetExecutionState.INACTIVE;
        switch (state.swigValue()) {
            case 0: 
            case 9: {
                exec = TargetExecutionStateful.TargetExecutionState.INACTIVE;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                exec = TargetExecutionStateful.TargetExecutionState.ALIVE;
                break;
            }
            case 5: {
                exec = TargetExecutionStateful.TargetExecutionState.STOPPED;
                this.onStopped();
                break;
            }
            case 6: 
            case 7: {
                exec = TargetExecutionStateful.TargetExecutionState.RUNNING;
                this.resetModified();
                this.onRunning();
                break;
            }
            case 10: {
                exec = TargetExecutionStateful.TargetExecutionState.TERMINATED;
                if (this.getParentProcess() != null || this instanceof TargetProcess) {
                    this.getManager().removeStateListener(this.accessListener);
                }
                this.onExit();
                break;
            }
            case 1: 
            case 8: {
                this.getModel().close();
                return;
            }
        }
        if (this instanceof LldbModelTargetExecutionStateful) {
            LldbModelTargetExecutionStateful stateful = (LldbModelTargetExecutionStateful)((Object)this);
            stateful.setExecutionState(exec, "Refreshed");
        }
    }

    @Override
    public CompletableFuture<? extends Map<String, ?>> requestNativeAttributes() {
        throw new AssertionError();
    }

    @Override
    public CompletableFuture<List<TargetObject>> requestNativeElements() {
        throw new AssertionError();
    }

    @Override
    public LldbModelTargetSession getParentSession() {
        LldbModelTargetObject test;
        for (test = (LldbModelTargetObject)this.parent; test != null && !(test instanceof LldbModelTargetSession); test = (LldbModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (LldbModelTargetSession)test;
    }

    @Override
    public LldbModelTargetProcess getParentProcess() {
        LldbModelTargetObject test;
        for (test = (LldbModelTargetObject)this.parent; test != null && !(test instanceof TargetProcess); test = (LldbModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (LldbModelTargetProcess)test;
    }

    @Override
    public LldbModelTargetThread getParentThread() {
        LldbModelTargetObject test;
        for (test = (LldbModelTargetObject)this.parent; test != null && !(test instanceof TargetThread); test = (LldbModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (LldbModelTargetThread)test;
    }

    @Override
    public void setModified(Map<String, Object> map, boolean b) {
        if (this.modified) {
            map.put("_modified", this.modified);
        }
    }

    @Override
    public void setModified(boolean modified) {
        if (modified) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", modified), "Refreshed");
        }
    }

    @Override
    public void resetModified() {
        this.changeAttributes(List.of(), List.of(), Map.of("_modified", false), "Refreshed");
    }

    public TargetObject searchForSuitable(Class<? extends TargetObject> type) {
        List pathToClass = this.model.getRootSchema().searchForSuitable(type, this.path);
        return this.model.getModelObject(pathToClass);
    }

    public String getDescription(int level) {
        return this.getName();
    }

    @Override
    public Object getModelObject() {
        return this.modelObject;
    }

    @Override
    public void setModelObject(Object modelObject) {
        if (modelObject != null) {
            ((LldbModelTargetObject)this.parent).addMapObject(modelObject, (TargetObject)this);
        }
        this.modelObject = modelObject;
    }

    @Override
    public void addMapObject(Object object, TargetObject targetObject) {
        if (object == null) {
            return;
        }
        this.objectMap.put(DebugClient.getModelKey(object), targetObject);
    }

    @Override
    public TargetObject getMapObject(Object object) {
        if (object == null) {
            return null;
        }
        return this.objectMap.get(DebugClient.getModelKey(object));
    }

    @Override
    public void deleteMapObject(Object object) {
        if (object == null) {
            return;
        }
        this.objectMap.remove(DebugClient.getModelKey(object));
    }
}

