/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractSymbolInternals;

public abstract class ReferenceSymbolInternals
extends AbstractSymbolInternals {
    protected long sumName;
    protected long offsetActualSymbolInDollarDollarSymbols;
    protected int moduleIndex;

    public static ReferenceSymbolInternals parseSt(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        ReferenceSymbolInternalsSt result = new ReferenceSymbolInternalsSt(pdb);
        result.sumName = reader.parseUnsignedIntVal();
        result.offsetActualSymbolInDollarDollarSymbols = reader.parseUnsignedIntVal();
        result.moduleIndex = reader.parseUnsignedShortVal();
        reader.align4();
        return result;
    }

    public static ReferenceSymbolInternals parse2(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        ReferenceSymbolInternals2 result = new ReferenceSymbolInternals2(pdb);
        result.sumName = reader.parseUnsignedIntVal();
        result.offsetActualSymbolInDollarDollarSymbols = reader.parseUnsignedIntVal();
        result.moduleIndex = reader.parseUnsignedShortVal();
        result.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        reader.align4();
        return result;
    }

    public ReferenceSymbolInternals(AbstractPdb pdb) {
        super(pdb);
    }

    public long getSumName() {
        return this.sumName;
    }

    public long getOffsetActualSymbolInDollarDollarSymbols() {
        return this.offsetActualSymbolInDollarDollarSymbols;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format(": %08X: (%4d, %08X)", this.sumName, this.moduleIndex, this.offsetActualSymbolInDollarDollarSymbols));
    }

    public static class ReferenceSymbolInternals2
    extends ReferenceSymbolInternals {
        protected String name;

        public ReferenceSymbolInternals2(AbstractPdb pdb) {
            super(pdb);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void emit(StringBuilder builder) {
            super.emit(builder);
            builder.append(" ");
            builder.append(this.name);
        }
    }

    public static class ReferenceSymbolInternalsSt
    extends ReferenceSymbolInternals {
        public ReferenceSymbolInternalsSt(AbstractPdb pdb) {
            super(pdb);
        }
    }
}

