/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.service.model.interfaces.AbstractRecorderMemory;
import ghidra.async.AsyncLazyMap;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.Msg;
import ghidra.util.TriConsumer;
import ghidra.util.datastruct.ListenerSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class RecorderComposedMemory
implements AbstractRecorderMemory {
    private static final int BLOCK_SIZE = 4096;
    private static final long BLOCK_MASK = -4096L;
    protected final RecorderComposedMemory chain;
    protected final NavigableMap<Address, TargetMemoryRegion> byMin = new TreeMap<Address, TargetMemoryRegion>();
    protected final Map<TargetMemoryRegion, TargetMemory> byRegion = new HashMap<TargetMemoryRegion, TargetMemory>();
    protected final AsyncLazyMap<TargetMemory, DebugModelConventions.AllRequiredAccess> accessibilityByMemory = new AsyncLazyMap<TargetMemory, DebugModelConventions.AllRequiredAccess>(new HashMap(), this::fetchMemAccessibility){

        public DebugModelConventions.AllRequiredAccess remove(TargetMemory key) {
            DebugModelConventions.AllRequiredAccess acc = (DebugModelConventions.AllRequiredAccess)super.remove((Object)key);
            if (acc != null) {
                acc.removeChangeListener((TriConsumer)RecorderComposedMemory.this.getMemAccListeners().fire);
            }
            return acc;
        }
    };
    private final ListenerSet<TriConsumer<Boolean, Boolean, Void>> memAccListeners = new ListenerSet(TriConsumer.class);

    protected CompletableFuture<DebugModelConventions.AllRequiredAccess> fetchMemAccessibility(TargetMemory mem) {
        return DebugModelConventions.trackAccessibility((TargetObject)mem).thenApply(acc -> {
            acc.addChangeListener((TriConsumer)this.getMemAccListeners().fire);
            return acc;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSet getAccessibleMemory(Predicate<TargetMemory> pred, DebuggerMemoryMapper memMapper) {
        AsyncLazyMap<TargetMemory, DebugModelConventions.AllRequiredAccess> asyncLazyMap = this.accessibilityByMemory;
        synchronized (asyncLazyMap) {
            AddressSet accessible = new AddressSet();
            for (Map.Entry<TargetMemoryRegion, TargetMemory> ent : this.byRegion.entrySet()) {
                DebugModelConventions.AllRequiredAccess acc;
                TargetMemory mem = ent.getValue();
                if (!pred.test(mem) || (acc = (DebugModelConventions.AllRequiredAccess)this.accessibilityByMemory.getCompletedMap().get(mem)) == null || !acc.getAllAccessibility()) continue;
                accessible.add(memMapper.targetToTrace(ent.getKey().getRange()));
            }
            return accessible;
        }
    }

    public RecorderComposedMemory(AbstractRecorderMemory memory) {
        this.chain = (RecorderComposedMemory)memory;
    }

    protected TargetMemory getMemory(Address address, int length) {
        Address max;
        Map.Entry<Address, TargetMemoryRegion> floor = this.findChainedFloor(address);
        if (floor == null) {
            throw new IllegalArgumentException("address " + address + " is not in any known region");
        }
        try {
            max = address.addNoWrap((long)(length - 1));
        }
        catch (AddressOverflowException e) {
            throw new IllegalArgumentException("read extends beyond the address space");
        }
        if (!floor.getValue().getRange().contains(max)) {
            throw new IllegalArgumentException("read extends beyond a single region");
        }
        return this.byRegion.get(floor.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegion(TargetMemoryRegion region, TargetMemory memory) {
        AsyncLazyMap<TargetMemory, DebugModelConventions.AllRequiredAccess> asyncLazyMap = this.accessibilityByMemory;
        synchronized (asyncLazyMap) {
            TargetMemory old = this.byRegion.put(region, memory);
            assert (old == null);
            this.byMin.put(region.getRange().getMinAddress(), region);
            this.accessibilityByMemory.get((Object)memory).exceptionally(e -> {
                e = AsyncUtils.unwrapThrowable((Throwable)e);
                Msg.error((Object)this, (Object)("Could not track memory accessibility: " + e.getMessage()));
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRegion(TargetObject invalid) {
        if (!(invalid instanceof TargetMemoryRegion)) {
            return false;
        }
        AsyncLazyMap<TargetMemory, DebugModelConventions.AllRequiredAccess> asyncLazyMap = this.accessibilityByMemory;
        synchronized (asyncLazyMap) {
            TargetMemoryRegion invRegion = (TargetMemoryRegion)invalid;
            TargetMemory old = this.byRegion.remove(invRegion);
            assert (old != null);
            this.byMin.remove(invRegion.getRange().getMinAddress());
            if (!old.isValid() || !this.byRegion.containsValue(old)) {
                this.accessibilityByMemory.remove((Object)old);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Address, TargetMemoryRegion> findChainedFloor(Address address) {
        AsyncLazyMap<TargetMemory, DebugModelConventions.AllRequiredAccess> asyncLazyMap = this.accessibilityByMemory;
        synchronized (asyncLazyMap) {
            Map.Entry<Address, TargetMemoryRegion> byChain;
            Map.Entry<Address, TargetMemoryRegion> myFloor = this.byMin.floorEntry(address);
            Map.Entry<Address, TargetMemoryRegion> entry = byChain = this.chain == null ? null : this.chain.findChainedFloor(address);
            if (byChain == null) {
                return myFloor;
            }
            if (myFloor == null) {
                return byChain;
            }
            int c = myFloor.getKey().compareTo((Object)byChain.getKey());
            if (c < 0) {
                return byChain;
            }
            return myFloor;
        }
    }

    protected AddressRange align(Address address, int length) {
        AddressSpace space = address.getAddressSpace();
        long offset = address.getOffset();
        Address start = space.getAddress(offset & 0xFFFFFFFFFFFFF000L);
        Address end = space.getAddress((offset + (long)length - 1L & 0xFFFFFFFFFFFFF000L) + 4096L - 1L);
        return new AddressRangeImpl(start, end);
    }

    protected AddressRange alignWithLimit(Address address, int length, TargetMemoryRegion limit) {
        return this.align(address, length).intersect(limit.getRange());
    }

    @Override
    public AddressRange alignAndLimitToFloor(Address address, int length) {
        Map.Entry<Address, TargetMemoryRegion> floor = this.findChainedFloor(address);
        if (floor == null) {
            return null;
        }
        return this.alignWithLimit(address, length, floor.getValue());
    }

    public AddressRange alignWithOptionalLimit(Address address, int length, TargetMemoryRegion limit) {
        if (limit == null) {
            return this.alignAndLimitToFloor(address, length);
        }
        return this.alignWithLimit(address, length, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<byte[]> readMemory(Address address, int length) {
        AsyncLazyMap<TargetMemory, DebugModelConventions.AllRequiredAccess> asyncLazyMap = this.accessibilityByMemory;
        synchronized (asyncLazyMap) {
            TargetMemory mem = this.getMemory(address, length);
            if (mem != null) {
                return mem.readMemory(address, length);
            }
            return CompletableFuture.completedFuture(new byte[0]);
        }
    }

    @Override
    public CompletableFuture<Void> writeMemory(Address address, byte[] data) {
        AsyncLazyMap<TargetMemory, DebugModelConventions.AllRequiredAccess> asyncLazyMap = this.accessibilityByMemory;
        synchronized (asyncLazyMap) {
            TargetMemory mem = this.getMemory(address, data.length);
            if (mem != null) {
                return mem.writeMemory(address, data);
            }
            throw new IllegalArgumentException("read starts outside any address space");
        }
    }

    public ListenerSet<TriConsumer<Boolean, Boolean, Void>> getMemAccListeners() {
        return this.memAccListeners;
    }
}

