/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import com.google.common.collect.Range;
import generic.CatenatedCollection;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.LogicalBreakpointInternal;
import ghidra.app.plugin.core.debug.service.breakpoint.LoneLogicalBreakpoint;
import ghidra.app.plugin.core.debug.service.breakpoint.MappedLogicalBreakpoint;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.app.services.LogicalBreakpointsChangeListener;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.datastruct.ListenerSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.collections4.IteratorUtils;

@PluginInfo(shortDescription="Debugger logical breakpoints service plugin", description="Aggregates breakpoints from open programs and live traces", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerModelService.class, DebuggerStaticMappingService.class}, servicesProvided={DebuggerLogicalBreakpointService.class})
public class DebuggerLogicalBreakpointServicePlugin
extends Plugin
implements DebuggerLogicalBreakpointService {
    private DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private DebuggerStaticMappingService mappingService;
    private final AutoService.Wiring autoServiceWiring;
    private final Object lock = new Object();
    private final ListenerSet<LogicalBreakpointsChangeListener> changeListeners = new ListenerSet(LogicalBreakpointsChangeListener.class);
    private final TrackRecordersListener recorderListener = new TrackRecordersListener();
    private final TrackMappingsListener mappingListener = new TrackMappingsListener();
    private final Map<Trace, InfoPerTrace> traceInfos = new HashMap<Trace, InfoPerTrace>();
    private final Map<Program, InfoPerProgram> programInfos = new HashMap<Program, InfoPerProgram>();
    private final Collection<AbstractInfo> allInfos = new CatenatedCollection(new Collection[]{this.traceInfos.values(), this.programInfos.values()});

    public DebuggerLogicalBreakpointServicePlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    }

    protected void removeLogicalBreakpointGlobally(LogicalBreakpoint lb) {
        InfoPerProgram info;
        ProgramLocation pLoc = lb.getProgramLocation();
        if (pLoc != null && (info = this.programInfos.get(pLoc.getProgram())) != null) {
            info.removeLogicalBreakpoint(pLoc.getByteAddress(), lb);
        }
        for (Trace t : lb.getMappedTraces()) {
            Address tAddr = lb.getTraceAddress(t);
            InfoPerTrace info2 = this.traceInfos.get(t);
            if (info2 == null) continue;
            info2.removeLogicalBreakpoint(tAddr, lb);
        }
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerModelService modelService) {
        if (this.modelService != null) {
            this.modelService.removeTraceRecordersChangedListener(this.recorderListener);
        }
        this.modelService = modelService;
        if (this.modelService != null) {
            this.modelService.addTraceRecordersChangedListener(this.recorderListener);
        }
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        if (this.mappingService != null) {
            this.mappingService.removeChangeListener(this.mappingListener);
        }
        this.mappingService = mappingService;
        if (this.mappingService != null) {
            this.mappingService.addChangeListener(this.mappingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void programOpened(Program program) {
        Object object = this.lock;
        synchronized (object) {
            if (program instanceof TraceProgramView) {
                return;
            }
            InfoPerProgram info = new InfoPerProgram(program);
            if (this.programInfos.put(program, info) != null) {
                throw new AssertionError((Object)"Already tracking program breakpoints");
            }
            info.reloadBreakpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void programClosed(Program program) {
        Object object = this.lock;
        synchronized (object) {
            if (program instanceof TraceProgramView) {
                return;
            }
            this.programInfos.remove(program).dispose();
        }
    }

    private void doTrackTrace(Trace trace, TraceRecorder recorder) {
        if (this.traceInfos.containsKey(trace)) {
            Msg.warn((Object)this, (Object)"Already tracking trace breakpoints");
            return;
        }
        InfoPerTrace info = new InfoPerTrace(recorder);
        this.traceInfos.put(trace, info);
        info.reloadBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUntrackTrace(Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.traceInfos.remove(trace);
            if (info != null) {
                info.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceRecordingStarted(TraceRecorder recorder) {
        Object object = this.lock;
        synchronized (object) {
            Trace trace = recorder.getTrace();
            if (!this.traceManager.getOpenTraces().contains(trace)) {
                return;
            }
            this.doTrackTrace(trace, recorder);
        }
    }

    private void traceRecordingStopped(TraceRecorder recorder) {
        this.doUntrackTrace(recorder.getTrace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceOpened(Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            TraceRecorder recorder = this.modelService.getRecorder(trace);
            if (recorder == null) {
                return;
            }
            this.doTrackTrace(trace, recorder);
        }
    }

    private void traceClosed(Trace trace) {
        this.doUntrackTrace(trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LogicalBreakpoint> getAllBreakpoints() {
        Object object = this.lock;
        synchronized (object) {
            HashSet<LogicalBreakpoint> records = new HashSet<LogicalBreakpoint>();
            for (AbstractInfo info : this.allInfos) {
                for (Set recsAtAddress : info.breakpointsByAddress.values()) {
                    records.addAll(recsAtAddress);
                }
            }
            return records;
        }
    }

    protected static <K, V> NavigableMap<K, Set<V>> copyOf(NavigableMap<? extends K, ? extends Set<? extends V>> map) {
        TreeMap result = new TreeMap();
        for (Map.Entry ent : map.entrySet()) {
            result.put(ent.getKey(), new HashSet((Collection)ent.getValue()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Program program) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.programInfos.get(program);
            if (info == null) {
                return Collections.emptyNavigableMap();
            }
            return DebuggerLogicalBreakpointServicePlugin.copyOf(info.breakpointsByAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.traceInfos.get(trace);
            if (info == null) {
                return Collections.emptyNavigableMap();
            }
            return DebuggerLogicalBreakpointServicePlugin.copyOf(info.breakpointsByAddress);
        }
    }

    protected Set<LogicalBreakpoint> doGetBreakpointsAt(AbstractInfo info, Address address) {
        Set set = (Set)info.breakpointsByAddress.get(address);
        if (set == null) {
            return Set.of();
        }
        return new HashSet<LogicalBreakpoint>(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LogicalBreakpoint> getBreakpointsAt(Program program, Address address) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.programInfos.get(program);
            if (info == null) {
                return Set.of();
            }
            return this.doGetBreakpointsAt(info, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LogicalBreakpoint> getBreakpointsAt(Trace trace, Address address) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.traceInfos.get(trace);
            if (info == null) {
                return Set.of();
            }
            return this.doGetBreakpointsAt(info, address);
        }
    }

    @Override
    public Set<LogicalBreakpoint> getBreakpointsAt(ProgramLocation loc) {
        return DebuggerLogicalBreakpointService.programOrTrace(loc, this::getBreakpointsAt, this::getBreakpointsAt);
    }

    @Override
    public void addChangeListener(LogicalBreakpointsChangeListener l) {
        this.changeListeners.add((Object)l);
    }

    @Override
    public void removeChangeListener(LogicalBreakpointsChangeListener l) {
        this.changeListeners.remove((Object)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> placeBreakpointAt(Program program, Address address, long length, Collection<TraceBreakpointKind> kinds) {
        MappedLogicalBreakpoint lb = new MappedLogicalBreakpoint(program, address, length, kinds);
        Object object = this.lock;
        synchronized (object) {
            for (InfoPerTrace ti : this.traceInfos.values()) {
                TraceLocation loc = ti.toDynamicLocation(lb.getProgramLocation());
                if (loc == null) continue;
                lb.setTraceAddress(ti.recorder, loc.getAddress());
            }
        }
        return lb.enable();
    }

    @Override
    public CompletableFuture<Void> placeBreakpointAt(Trace trace, Address address, long length, Collection<TraceBreakpointKind> kinds) {
        TraceRecorder recorder = this.modelService.getRecorder(trace);
        if (recorder == null) {
            throw new IllegalArgumentException("Given trace is not live");
        }
        return new LoneLogicalBreakpoint(recorder, address, length, kinds).enableForTrace(trace);
    }

    @Override
    public CompletableFuture<Void> placeBreakpointAt(ProgramLocation loc, long length, Collection<TraceBreakpointKind> kinds) {
        return DebuggerLogicalBreakpointService.programOrTrace(loc, (p, a) -> this.placeBreakpointAt((Program)p, (Address)a, length, kinds), (t, a) -> this.placeBreakpointAt((Trace)t, (Address)a, length, kinds));
    }

    protected CompletableFuture<Void> actOnAll(Collection<LogicalBreakpoint> col, Trace trace, Consumer<LogicalBreakpoint> consumerForProgram, BiConsumer<BreakpointActionSet, LogicalBreakpointInternal> consumerForTarget) {
        BreakpointActionSet actions = new BreakpointActionSet();
        for (LogicalBreakpoint lb : col) {
            if (trace == null) {
                consumerForProgram.accept(lb);
            }
            if (!(lb instanceof LogicalBreakpointInternal)) continue;
            LogicalBreakpointInternal lbi = (LogicalBreakpointInternal)lb;
            consumerForTarget.accept(actions, lbi);
        }
        return actions.execute();
    }

    @Override
    public CompletableFuture<Void> enableAll(Collection<LogicalBreakpoint> col, Trace trace) {
        return this.actOnAll(col, trace, LogicalBreakpoint::enableForProgram, (actions, lbi) -> lbi.planEnable((BreakpointActionSet)actions, trace));
    }

    @Override
    public CompletableFuture<Void> disableAll(Collection<LogicalBreakpoint> col, Trace trace) {
        return this.actOnAll(col, trace, LogicalBreakpoint::disableForProgram, (actions, lbi) -> lbi.planDisable((BreakpointActionSet)actions, trace));
    }

    @Override
    public CompletableFuture<Void> deleteAll(Collection<LogicalBreakpoint> col, Trace trace) {
        return this.actOnAll(col, trace, LogicalBreakpoint::deleteForProgram, (actions, lbi) -> lbi.planDelete((BreakpointActionSet)actions, trace));
    }

    protected CompletableFuture<Void> actOnLocs(Collection<TraceBreakpoint> col, BiConsumer<BreakpointActionSet, TargetBreakpointLocation> consumer) {
        BreakpointActionSet actions = new BreakpointActionSet();
        for (TraceBreakpoint tb : col) {
            TraceRecorder recorder = this.modelService.getRecorder(tb.getTrace());
            if (recorder == null) continue;
            List path = PathUtils.parse((String)tb.getPath());
            TargetObject object = recorder.getTarget().getModel().getModelObject(path);
            if (!(object instanceof TargetBreakpointLocation)) {
                Msg.error((Object)this, (Object)(tb.getPath() + " is not a target breakpoint location"));
                continue;
            }
            TargetBreakpointLocation loc = (TargetBreakpointLocation)object;
            consumer.accept(actions, loc);
        }
        return actions.execute();
    }

    @Override
    public CompletableFuture<Void> enableLocs(Collection<TraceBreakpoint> col) {
        return this.actOnLocs(col, BreakpointActionSet::planEnable);
    }

    @Override
    public CompletableFuture<Void> disableLocs(Collection<TraceBreakpoint> col) {
        return this.actOnLocs(col, BreakpointActionSet::planDisable);
    }

    @Override
    public CompletableFuture<Void> deleteLocs(Collection<TraceBreakpoint> col) {
        return this.actOnLocs(col, BreakpointActionSet::planDelete);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent openedEvt = (ProgramOpenedPluginEvent)event;
            this.programOpened(openedEvt.getProgram());
        } else if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent closedEvt = (ProgramClosedPluginEvent)event;
            this.programClosed(closedEvt.getProgram());
        } else if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent openedEvt = (TraceOpenedPluginEvent)event;
            this.traceOpened(openedEvt.getTrace());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent closedEvt = (TraceClosedPluginEvent)event;
            this.traceClosed(closedEvt.getTrace());
        }
    }

    protected class InfoPerProgram
    extends AbstractInfo {
        final Program program;
        final ProgramBreakpointsListener breakpointListener;

        public InfoPerProgram(Program program) {
            this.program = program;
            this.breakpointListener = new ProgramBreakpointsListener(this);
            program.addListener((DomainObjectListener)this.breakpointListener);
        }

        protected void mapTraceAddresses(LogicalBreakpointInternal lb) {
            for (InfoPerTrace ti : DebuggerLogicalBreakpointServicePlugin.this.traceInfos.values()) {
                TraceLocation loc = ti.toDynamicLocation(lb.getProgramLocation());
                if (loc == null) continue;
                lb.setTraceAddress(ti.recorder, loc.getAddress());
                ti.breakpointsByAddress.computeIfAbsent(loc.getAddress(), __ -> new HashSet()).add(lb);
            }
        }

        @Override
        protected LogicalBreakpointInternal createLogicalBreakpoint(Address address, long length, Collection<TraceBreakpointKind> kinds) {
            MappedLogicalBreakpoint lb = new MappedLogicalBreakpoint(this.program, address, length, kinds);
            this.mapTraceAddresses(lb);
            return lb;
        }

        protected LogicalBreakpointInternal getOrCreateLogicalBreakpointFor(Bookmark bookmark, AddCollector c) {
            Address address = bookmark.getAddress();
            Set set = this.breakpointsByAddress.computeIfAbsent(address, __ -> new HashSet());
            for (LogicalBreakpointInternal lb : set) {
                if (!lb.canMerge(this.program, bookmark)) continue;
                return lb;
            }
            LogicalBreakpointInternal lb = this.createLogicalBreakpoint(address, LogicalBreakpointInternal.ProgramBreakpoint.lengthFromBookmark(bookmark), LogicalBreakpointInternal.ProgramBreakpoint.kindsFromBookmark(bookmark));
            set.add(lb);
            c.added(lb);
            return lb;
        }

        protected LogicalBreakpointInternal removeFromLogicalBreakpoint(Bookmark bookmark, RemoveCollector c) {
            Address address = bookmark.getAddress();
            Set set = (Set)this.breakpointsByAddress.get(address);
            if (set == null) {
                Msg.error((Object)this, (Object)("Breakpoint " + bookmark + " was not tracked before removal!"));
                return null;
            }
            for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                if (!lb.untrackBreakpoint(this.program, bookmark)) continue;
                if (lb.isEmpty()) {
                    this.removeLogicalBreakpoint(address, lb);
                    DebuggerLogicalBreakpointServicePlugin.this.removeLogicalBreakpointGlobally(lb);
                    c.removed(lb);
                } else {
                    c.updated(lb);
                }
                return lb;
            }
            Msg.error((Object)this, (Object)("Breakpoint " + bookmark + " was not tracked before removal!"));
            return null;
        }

        @Override
        protected void dispose() {
            this.program.removeListener((DomainObjectListener)this.breakpointListener);
            try (RemoveCollector r = new RemoveCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                this.forgetAllBreakpoints(r);
            }
        }

        protected void reloadBreakpoints() {
            try (AddCollector a = new AddCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);
                 RemoveCollector r = new RemoveCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                this.forgetProgramInvalidBreakpoints(r);
                this.trackAllProgramBreakpoints(a);
                a.deconflict(r);
            }
        }

        protected void forgetAllBreakpoints(RemoveCollector r) {
            ArrayList marks = new ArrayList();
            this.program.getBookmarkManager().getBookmarksIterator("BreakpointEnabled").forEachRemaining(marks::add);
            this.program.getBookmarkManager().getBookmarksIterator("BreakpointDisabled").forEachRemaining(marks::add);
            for (Bookmark bm : marks) {
                this.forgetProgramBreakpoint(bm, r);
            }
        }

        protected void forgetProgramInvalidBreakpoints(RemoveCollector r) {
            for (Set set : List.copyOf(this.breakpointsByAddress.values())) {
                for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                    Bookmark bm = lb.getProgramBookmark();
                    if (bm == null) continue;
                    if (bm != this.program.getBookmarkManager().getBookmark(bm.getId())) {
                        this.forgetProgramBreakpoint(bm, r);
                        continue;
                    }
                    if (lb.getProgramLocation().getByteAddress().equals((Object)bm.getAddress())) continue;
                    this.forgetProgramBreakpoint(bm, r);
                }
            }
        }

        protected void trackAllProgramBreakpoints(AddCollector c) {
            BookmarkManager bookmarks = this.program.getBookmarkManager();
            this.trackProgramBreakpoints(IteratorUtils.asIterable((Iterator)bookmarks.getBookmarksIterator("BreakpointEnabled")), c);
            this.trackProgramBreakpoints(IteratorUtils.asIterable((Iterator)bookmarks.getBookmarksIterator("BreakpointDisabled")), c);
        }

        protected void trackProgramBreakpoints(Iterable<Bookmark> breakpoints, AddCollector c) {
            for (Bookmark b : breakpoints) {
                this.trackProgramBreakpoint(b, c);
            }
        }

        protected void trackProgramBreakpoint(Bookmark breakpoint, AddCollector c) {
            LogicalBreakpointInternal lb = this.getOrCreateLogicalBreakpointFor(breakpoint, c);
            assert (((Set)this.breakpointsByAddress.get(breakpoint.getAddress())).contains(lb));
            if (lb.trackBreakpoint(breakpoint)) {
                c.updated(lb);
            }
        }

        protected void forgetProgramBreakpoint(Bookmark breakpoint, RemoveCollector c) {
            LogicalBreakpointInternal lb = this.removeFromLogicalBreakpoint(breakpoint, c);
            if (lb == null) {
                return;
            }
            assert (lb.isEmpty() == (this.breakpointsByAddress.get(breakpoint.getAddress()) == null || !((Set)this.breakpointsByAddress.get(breakpoint.getAddress())).contains(lb)));
        }
    }

    protected class InfoPerTrace
    extends AbstractInfo {
        final TraceRecorder recorder;
        final Trace trace;
        final TraceBreakpointsListener breakpointListener;

        public InfoPerTrace(TraceRecorder recorder) {
            this.recorder = recorder;
            this.trace = recorder.getTrace();
            this.breakpointListener = new TraceBreakpointsListener(this);
            this.trace.addListener((DomainObjectListener)this.breakpointListener);
        }

        @Override
        protected LogicalBreakpointInternal createLogicalBreakpoint(Address address, long length, Collection<TraceBreakpointKind> kinds) {
            return new LoneLogicalBreakpoint(this.recorder, address, length, kinds);
        }

        @Override
        protected void dispose() {
            this.trace.removeListener((DomainObjectListener)this.breakpointListener);
            try (RemoveCollector r = new RemoveCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                this.forgetAllBreakpoints(r);
            }
        }

        protected void reloadBreakpoints() {
            try (AddCollector a = new AddCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);
                 RemoveCollector r = new RemoveCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                this.forgetTraceInvalidBreakpoints(r);
                this.trackTraceLiveBreakpoints(a);
                a.deconflict(r);
            }
        }

        protected void forgetAllBreakpoints(RemoveCollector r) {
            ArrayList live = new ArrayList();
            for (AddressRange range : this.trace.getBaseAddressFactory().getAddressSet()) {
                live.addAll(this.trace.getBreakpointManager().getBreakpointsIntersecting(Range.singleton((Comparable)Long.valueOf(this.recorder.getSnap())), range));
            }
            for (TraceBreakpoint b : live) {
                this.forgetTraceBreakpoint(b, r);
            }
        }

        protected void forgetTraceInvalidBreakpoints(RemoveCollector r) {
            for (Set set : List.copyOf(this.breakpointsByAddress.values())) {
                for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                    for (TraceBreakpoint tb : Set.copyOf(lb.getTraceBreakpoints(this.trace))) {
                        if (!this.trace.getBreakpointManager().getAllBreakpoints().contains(tb)) {
                            this.forgetTraceBreakpoint(tb, r);
                            continue;
                        }
                        ProgramLocation progLoc = this.computeStaticLocation(tb);
                        if (Objects.equals(lb.getProgramLocation(), progLoc)) continue;
                        this.forgetTraceBreakpoint(tb, r);
                    }
                }
            }
        }

        protected void trackTraceLiveBreakpoints(AddCollector c) {
            ArrayList<TraceBreakpoint> live = new ArrayList<TraceBreakpoint>();
            for (AddressRange range : this.trace.getBaseAddressFactory().getAddressSet()) {
                live.addAll(this.trace.getBreakpointManager().getBreakpointsIntersecting(Range.singleton((Comparable)Long.valueOf(this.recorder.getSnap())), range));
            }
            this.trackTraceBreakpoints(live, c);
        }

        protected void trackTraceBreakpoints(Collection<TraceBreakpoint> breakpoints, AddCollector collector) {
            for (TraceBreakpoint b : breakpoints) {
                this.trackTraceBreakpoint(b, collector, false);
            }
        }

        protected ProgramLocation computeStaticLocation(TraceBreakpoint breakpoint) {
            if (DebuggerLogicalBreakpointServicePlugin.this.traceManager == null || !DebuggerLogicalBreakpointServicePlugin.this.traceManager.getOpenTraces().contains(breakpoint.getTrace())) {
                return null;
            }
            return DebuggerLogicalBreakpointServicePlugin.this.mappingService.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(this.trace, null, Range.singleton((Comparable)Long.valueOf(this.recorder.getSnap())), breakpoint.getMinAddress()));
        }

        protected void trackTraceBreakpoint(TraceBreakpoint breakpoint, AddCollector c, boolean forceUpdate) {
            LogicalBreakpointInternal lb;
            Address traceAddr = breakpoint.getMinAddress();
            ProgramLocation progLoc = this.computeStaticLocation(breakpoint);
            if (progLoc != null) {
                InfoPerProgram progInfo = DebuggerLogicalBreakpointServicePlugin.this.programInfos.get(progLoc.getProgram());
                lb = progInfo.getOrCreateLogicalBreakpointFor(progLoc.getByteAddress(), breakpoint, c);
            } else {
                lb = this.getOrCreateLogicalBreakpointFor(traceAddr, breakpoint, c);
            }
            assert (((Set)this.breakpointsByAddress.get(traceAddr)).contains(lb));
            if (forceUpdate || lb.trackBreakpoint(breakpoint)) {
                c.updated(lb);
            }
        }

        protected void forgetTraceBreakpoint(TraceBreakpoint breakpoint, RemoveCollector c) {
            LogicalBreakpointInternal lb = this.removeFromLogicalBreakpoint(breakpoint.getMinAddress(), breakpoint, c);
            if (lb == null) {
                return;
            }
            assert (lb.isEmpty() == (this.breakpointsByAddress.get(breakpoint.getMinAddress()) == null || !((Set)this.breakpointsByAddress.get(breakpoint.getMinAddress())).contains(lb)));
        }

        public TraceLocation toDynamicLocation(ProgramLocation loc) {
            return DebuggerLogicalBreakpointServicePlugin.this.mappingService.getOpenMappedLocation(this.trace, loc, this.recorder.getSnap());
        }
    }

    protected abstract class AbstractInfo {
        final NavigableMap<Address, Set<LogicalBreakpointInternal>> breakpointsByAddress = new TreeMap<Address, Set<LogicalBreakpointInternal>>();

        protected abstract void dispose();

        protected abstract LogicalBreakpointInternal createLogicalBreakpoint(Address var1, long var2, Collection<TraceBreakpointKind> var4);

        protected LogicalBreakpointInternal getOrCreateLogicalBreakpointFor(Address address, TraceBreakpoint breakpoint, AddCollector c) {
            Set set = this.breakpointsByAddress.computeIfAbsent(address, a -> new HashSet());
            for (LogicalBreakpointInternal lb : set) {
                if (!lb.canMerge(breakpoint)) continue;
                return lb;
            }
            LogicalBreakpointInternal lb = this.createLogicalBreakpoint(address, breakpoint.getLength(), breakpoint.getKinds());
            set.add(lb);
            c.added(lb);
            return lb;
        }

        protected LogicalBreakpointInternal removeFromLogicalBreakpoint(Address address, TraceBreakpoint breakpoint, RemoveCollector c) {
            Set set = (Set)this.breakpointsByAddress.get(address);
            if (set == null) {
                Msg.warn((Object)this, (Object)("Breakpoint to remove is not present: " + breakpoint + ", trace=" + breakpoint.getTrace()));
                return null;
            }
            for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                if (!lb.untrackBreakpoint(breakpoint)) continue;
                if (lb.isEmpty()) {
                    this.removeLogicalBreakpoint(address, lb);
                    DebuggerLogicalBreakpointServicePlugin.this.removeLogicalBreakpointGlobally(lb);
                    c.removed(lb);
                } else {
                    c.updated(lb);
                }
                return lb;
            }
            Msg.warn((Object)this, (Object)("Breakpoint to remove is not present: " + breakpoint + ", trace=" + breakpoint.getTrace()));
            return null;
        }

        protected boolean removeLogicalBreakpoint(Address address, LogicalBreakpoint lb) {
            Set set = (Set)this.breakpointsByAddress.get(address);
            if (set == null) {
                return false;
            }
            if (!set.remove(lb)) {
                return false;
            }
            if (set.isEmpty()) {
                this.breakpointsByAddress.remove(address);
            }
            return true;
        }

        protected boolean isMismapped(LogicalBreakpointInternal lb) {
            if (!(lb instanceof MappedLogicalBreakpoint)) {
                return false;
            }
            HashSet<Trace> extraneous = new HashSet<Trace>(lb.getMappedTraces());
            extraneous.removeAll(DebuggerLogicalBreakpointServicePlugin.this.traceInfos.keySet());
            if (!extraneous.isEmpty()) {
                return true;
            }
            for (InfoPerTrace ti : DebuggerLogicalBreakpointServicePlugin.this.traceInfos.values()) {
                TraceLocation loc = ti.toDynamicLocation(lb.getProgramLocation());
                if (!(loc == null ? lb.getTraceAddress(ti.trace) != null : !loc.getAddress().equals((Object)lb.getTraceAddress(ti.trace)))) continue;
                return true;
            }
            return false;
        }

        protected void forgetMismappedBreakpoints(RemoveCollector c, Set<Trace> additionalTraces, Set<Program> additionalPrograms) {
            for (Set set : List.copyOf(this.breakpointsByAddress.values())) {
                for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                    if (!this.isMismapped(lb)) continue;
                    DebuggerLogicalBreakpointServicePlugin.this.removeLogicalBreakpointGlobally(lb);
                    c.removed(lb);
                    additionalTraces.addAll(lb.getParticipatingTraces());
                }
            }
        }
    }

    private class ProgramBreakpointsListener
    extends TraceDomainObjectListener {
        private final InfoPerProgram info;

        public ProgramBreakpointsListener(InfoPerProgram info) {
            this.info = info;
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenForUntyped(122, this.onBreakpoint(this::breakpointBookmarkAdded));
            this.listenForUntyped(124, this.onBreakpoint(this::breakpointBookmarkChanged));
            this.listenForUntyped(123, this.onBreakpoint(this::breakpointBookmarkDeleted));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void objectRestored() {
            Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
            synchronized (object) {
                this.info.reloadBreakpoints();
            }
        }

        private Consumer<DomainObjectChangeRecord> onBreakpoint(Consumer<Bookmark> handler) {
            return rec -> {
                ProgramChangeRecord pcrec = (ProgramChangeRecord)rec;
                Bookmark bm = (Bookmark)pcrec.getObject();
                String bmType = bm.getTypeString();
                if ("BreakpointEnabled".equals(bmType) || "BreakpointDisabled".equals(bmType)) {
                    handler.accept(bm);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void breakpointBookmarkAdded(Bookmark bookmark) {
            try (AddCollector c = new AddCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
                synchronized (object) {
                    this.info.trackProgramBreakpoint(bookmark, c);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void breakpointBookmarkChanged(Bookmark bookmark) {
            Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
            synchronized (object) {
                this.breakpointBookmarkDeleted(bookmark);
                this.breakpointBookmarkAdded(bookmark);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void breakpointBookmarkDeleted(Bookmark bookmark) {
            try (RemoveCollector c = new RemoveCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
                synchronized (object) {
                    this.info.forgetProgramBreakpoint(bookmark, c);
                }
            }
        }
    }

    private class TraceBreakpointsListener
    extends TraceDomainObjectListener {
        private final InfoPerTrace info;

        public TraceBreakpointsListener(InfoPerTrace info) {
            this.info = info;
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.ADDED, this::breakpointAdded);
            this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.CHANGED, this::breakpointChanged);
            this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.LIFESPAN_CHANGED, this::breakpointLifespanChanged);
            this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.DELETED, this::breakpointDeleted);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void objectRestored() {
            Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
            synchronized (object) {
                this.info.reloadBreakpoints();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void breakpointAdded(TraceBreakpoint breakpoint) {
            if (!breakpoint.getLifespan().contains((Comparable)Long.valueOf(this.info.recorder.getSnap()))) {
                return;
            }
            try (AddCollector c = new AddCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
                synchronized (object) {
                    this.info.trackTraceBreakpoint(breakpoint, c, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void breakpointChanged(TraceBreakpoint breakpoint) {
            if (!breakpoint.getLifespan().contains((Comparable)Long.valueOf(this.info.recorder.getSnap()))) {
                return;
            }
            try (AddCollector c = new AddCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
                synchronized (object) {
                    this.info.trackTraceBreakpoint(breakpoint, c, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void breakpointLifespanChanged(TraceAddressSpace spaceIsNull, TraceBreakpoint breakpoint, Range<Long> oldSpan, Range<Long> newSpan) {
            block18: {
                boolean isInNew;
                boolean isInOld = oldSpan.contains((Comparable)Long.valueOf(this.info.recorder.getSnap()));
                if (isInOld == (isInNew = newSpan.contains((Comparable)Long.valueOf(this.info.recorder.getSnap())))) {
                    return;
                }
                if (isInOld) {
                    try (RemoveCollector c = new RemoveCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                        Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
                        synchronized (object) {
                            this.info.forgetTraceBreakpoint(breakpoint, c);
                            break block18;
                        }
                    }
                }
                try (AddCollector c = new AddCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                    Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
                    synchronized (object) {
                        this.info.trackTraceBreakpoint(breakpoint, c, false);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void breakpointDeleted(TraceBreakpoint breakpoint) {
            if (!breakpoint.getLifespan().contains((Comparable)Long.valueOf(this.info.recorder.getSnap()))) {
                assert (false);
                return;
            }
            try (RemoveCollector c = new RemoveCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
                synchronized (object) {
                    this.info.forgetTraceBreakpoint(breakpoint, c);
                }
            }
        }
    }

    protected class TrackMappingsListener
    implements DebuggerStaticMappingChangeListener {
        protected TrackMappingsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            Object object = DebuggerLogicalBreakpointServicePlugin.this.lock;
            synchronized (object) {
                AbstractInfo info;
                HashSet<Trace> additionalTraces = new HashSet<Trace>(affectedTraces);
                HashSet<Program> additionalPrograms = new HashSet<Program>(affectedPrograms);
                try (RemoveCollector r = new RemoveCollector((LogicalBreakpointsChangeListener)DebuggerLogicalBreakpointServicePlugin.this.changeListeners.fire);){
                    AbstractInfo info2;
                    for (Trace t : affectedTraces) {
                        info2 = DebuggerLogicalBreakpointServicePlugin.this.traceInfos.get(t);
                        if (info2 == null) continue;
                        info2.forgetMismappedBreakpoints(r, additionalTraces, additionalPrograms);
                    }
                    for (Program p : affectedPrograms) {
                        info2 = DebuggerLogicalBreakpointServicePlugin.this.programInfos.get(p);
                        if (info2 == null) continue;
                        info2.forgetMismappedBreakpoints(r, additionalTraces, additionalPrograms);
                    }
                }
                for (Trace t : additionalTraces) {
                    info = DebuggerLogicalBreakpointServicePlugin.this.traceInfos.get(t);
                    if (info == null) continue;
                    ((InfoPerTrace)info).reloadBreakpoints();
                }
                for (Program p : additionalPrograms) {
                    info = DebuggerLogicalBreakpointServicePlugin.this.programInfos.get(p);
                    if (info == null) continue;
                    ((InfoPerProgram)info).reloadBreakpoints();
                }
            }
        }
    }

    protected class TrackRecordersListener
    implements CollectionChangeListener<TraceRecorder> {
        protected TrackRecordersListener() {
        }

        public void elementAdded(TraceRecorder element) {
            Swing.runIfSwingOrRunLater(() -> DebuggerLogicalBreakpointServicePlugin.this.traceRecordingStarted(element));
        }

        public void elementRemoved(TraceRecorder element) {
            Swing.runIfSwingOrRunLater(() -> DebuggerLogicalBreakpointServicePlugin.this.traceRecordingStopped(element));
        }
    }

    private static class RemoveCollector
    implements AutoCloseable {
        private final LogicalBreakpointsChangeListener l;
        private final Set<LogicalBreakpoint> removed = new HashSet<LogicalBreakpoint>();
        private final Set<LogicalBreakpoint> updated = new HashSet<LogicalBreakpoint>();

        public RemoveCollector(LogicalBreakpointsChangeListener l) {
            this.l = l;
        }

        protected void updated(LogicalBreakpoint lb) {
            this.updated.add(lb);
        }

        protected void removed(LogicalBreakpoint lb) {
            this.removed.add(lb);
        }

        @Override
        public void close() {
            this.updated.removeAll(this.removed);
            if (!this.removed.isEmpty()) {
                this.l.breakpointsRemoved(this.removed);
            }
            if (!this.updated.isEmpty()) {
                this.l.breakpointsUpdated(this.updated);
            }
        }
    }

    private static class AddCollector
    implements AutoCloseable {
        private final LogicalBreakpointsChangeListener l;
        private final Set<LogicalBreakpoint> added = new HashSet<LogicalBreakpoint>();
        private final Set<LogicalBreakpoint> updated = new HashSet<LogicalBreakpoint>();

        public AddCollector(LogicalBreakpointsChangeListener l) {
            this.l = l;
        }

        protected void added(LogicalBreakpoint lb) {
            this.added.add(lb);
        }

        protected void updated(LogicalBreakpoint lb) {
            this.updated.add(lb);
        }

        @Override
        public void close() {
            this.updated.removeAll(this.added);
            if (!this.updated.isEmpty()) {
                this.l.breakpointsUpdated(this.updated);
            }
            if (!this.added.isEmpty()) {
                this.l.breakpointsAdded(this.added);
            }
        }

        public void deconflict(RemoveCollector r) {
            this.updated.addAll(r.updated);
            r.updated.clear();
        }
    }
}

