/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import com.google.common.collect.Range;
import db.DBHandle;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.module.DBTraceModule;
import ghidra.trace.database.module.DBTraceModuleSpace;
import ghidra.trace.database.module.DBTraceSection;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceModuleManager
extends AbstractDBTraceSpaceBasedManager<DBTraceModuleSpace, DBTraceModuleSpace>
implements TraceModuleManager,
DBTraceDelegatingManager<DBTraceModuleSpace> {
    public static final String NAME = "Module";

    public DBTraceModuleManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace) throws VersionException, IOException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, null);
        this.loadSpaces();
    }

    @Override
    public DBTraceModuleSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceModuleSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    protected DBTraceModuleSpace getForRegisterSpace(TraceThread thread, int frameLevel, boolean createIfAbsent) {
        throw new UnsupportedOperationException();
    }

    protected void checkModulePathConflicts(DBTraceModule ignore, String modulePath, Range<Long> moduleLifespan) throws DuplicateNameException {
        for (DBTraceModule dBTraceModule : this.doGetModulesByPath(modulePath)) {
            if (dBTraceModule == ignore || !DBTraceUtils.intersect(dBTraceModule.getLifespan(), moduleLifespan)) continue;
            throw new DuplicateNameException("Module with path '" + modulePath + "' already exists within an overlapping snap");
        }
    }

    protected void checkSectionPathConflicts(DBTraceSection ignore, String sectionPath, Range<Long> moduleLifespan) throws DuplicateNameException {
        Collection<? extends DBTraceSection> pathConflicts = this.doGetSectionsByPath(sectionPath);
        for (DBTraceSection dBTraceSection : pathConflicts) {
            if (dBTraceSection == ignore || !DBTraceUtils.intersect(dBTraceSection.getLifespan(), moduleLifespan)) continue;
            throw new DuplicateNameException("Section with path '" + sectionPath + "' already exists within an overlapping snap");
        }
    }

    @Override
    public DBTraceModule addModule(String modulePath, String moduleName, AddressRange range, Range<Long> lifespan) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceModule dBTraceModule = this.doAddModule(modulePath, moduleName, range, lifespan);
            return dBTraceModule;
        }
    }

    protected DBTraceModule doAddModule(String modulePath, String moduleName, AddressRange range, Range<Long> lifespan) throws DuplicateNameException {
        this.checkModulePathConflicts(null, modulePath, lifespan);
        return (DBTraceModule)this.delegateWrite(range.getAddressSpace(), m -> m.doAddModule(modulePath, moduleName, range, lifespan));
    }

    protected Collection<? extends DBTraceModule> doGetModulesByPath(String modulePath) {
        return this.delegateCollection(this.memSpaces.values(), m -> m.doGetModulesByPath(modulePath));
    }

    public Collection<? extends DBTraceModule> getModulesByPath(String modulePath) {
        return Collections.unmodifiableCollection(this.doGetModulesByPath(modulePath));
    }

    @Override
    public DBTraceModule getLoadedModuleByPath(long snap, String modulePath) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            DBTraceModule dBTraceModule = this.doGetModulesByPath(modulePath).stream().filter(m -> m.getLifespan().contains((Comparable)Long.valueOf(snap))).findAny().orElse(null);
            return dBTraceModule;
        }
    }

    public Collection<? extends DBTraceModule> getAllModules() {
        return this.delegateCollection(this.memSpaces.values(), m -> m.getAllModules());
    }

    public Collection<? extends DBTraceModule> getLoadedModules(long snap) {
        return this.delegateCollection(this.memSpaces.values(), m -> m.getLoadedModules(snap));
    }

    public Collection<? extends DBTraceModule> getModulesAt(long snap, Address address) {
        return (Collection)this.delegateRead(address.getAddressSpace(), m -> m.getModulesAt(snap, address), Set.of());
    }

    public Collection<? extends DBTraceModule> getModulesIntersecting(Range<Long> lifespan, AddressRange range) {
        return (Collection)this.delegateRead(range.getAddressSpace(), m -> m.getModulesIntersecting(lifespan, range), Set.of());
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }

    public Collection<? extends DBTraceSection> getSectionsAt(long snap, Address address) {
        return (Collection)this.delegateRead(address.getAddressSpace(), m -> m.getSectionsAt(snap, address), Set.of());
    }

    public Collection<? extends DBTraceSection> getSectionsIntersecting(Range<Long> lifespan, AddressRange range) {
        return (Collection)this.delegateRead(range.getAddressSpace(), m -> m.getSectionsIntersecting(lifespan, range), Set.of());
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    protected DBTraceModuleSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceModuleSpace(this, space);
    }

    @Override
    protected DBTraceModuleSpace createRegisterSpace(AddressSpace space, DBTraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        throw new AssertionError();
    }

    protected DBTraceSection doAddSection(DBTraceModule module, String sectionPath, String sectionName, AddressRange range) throws DuplicateNameException {
        this.checkSectionPathConflicts(null, sectionPath, module.getLifespan());
        DBTraceSection nameConflicts = this.doGetSectionByName(module.getKey(), sectionName);
        if (nameConflicts != null) {
            throw new DuplicateNameException("Section with name '" + sectionName + "' already exists");
        }
        return (DBTraceSection)this.delegateWrite(range.getAddressSpace(), m -> m.doAddSection(module, sectionPath, sectionName, range));
    }

    public Collection<? extends DBTraceSection> getAllSections() {
        return this.delegateCollection(this.memSpaces.values(), m -> m.getAllSections());
    }

    protected Collection<? extends DBTraceSection> doGetSectionsByModuleId(long key) {
        return this.delegateCollection(this.memSpaces.values(), m -> m.doGetSectionsByModuleId(key));
    }

    protected Collection<? extends DBTraceSection> doGetSectionsByPath(String sectionPath) {
        return this.delegateCollection(this.memSpaces.values(), m -> m.doGetSectionsByPath(sectionPath));
    }

    public Collection<? extends DBTraceSection> getSectionsByPath(String sectionPath) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Collection<? extends DBTraceSection> collection = Collections.unmodifiableCollection(this.doGetSectionsByPath(sectionPath));
            return collection;
        }
    }

    @Override
    public TraceSection getLoadedSectionByPath(long snap, String sectionPath) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            TraceSection traceSection = this.doGetSectionsByPath(sectionPath).stream().filter(s -> s.getLifespan().contains((Comparable)Long.valueOf(snap))).findAny().orElse(null);
            return traceSection;
        }
    }

    protected DBTraceSection doGetSectionByName(long moduleKey, String sectionName) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            DBTraceSection dBTraceSection = (DBTraceSection)this.delegateFirst(this.memSpaces.values(), m -> m.doGetSectionByName(moduleKey, sectionName));
            return dBTraceSection;
        }
    }

    protected void doDeleteModule(DBTraceModule module) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (DBTraceSection dBTraceSection : new ArrayList<DBTraceSection>(this.doGetSectionsByModuleId(module.getKey()))) {
                dBTraceSection.space.sectionMapSpace.deleteData(dBTraceSection);
            }
            module.space.moduleMapSpace.deleteData(module);
        }
        this.trace.setChanged(new TraceChangeRecord(Trace.TraceModuleChangeType.DELETED, null, module));
    }
}

