/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class MinimumSpanningForest<V, E> {
    protected Graph<V, E> graph;
    protected Forest<V, E> forest;
    protected Function<E, Double> weights;

    public MinimumSpanningForest(Graph<V, E> graph, Supplier<Forest<V, E>> Supplier2, V root, Map<E, Double> weights) {
        this(graph, (Forest)Supplier2.get(), root, weights);
    }

    public MinimumSpanningForest(Graph<V, E> graph, Forest<V, E> forest, V root, Map<E, Double> weights) {
        if (forest.getVertexCount() != 0) {
            throw new IllegalArgumentException("Supplied Forest must be empty");
        }
        this.graph = graph;
        this.forest = forest;
        if (weights != null) {
            this.weights = Functions.forMap(weights);
        }
        HashSet unfinishedEdges = new HashSet(graph.getEdges());
        if (graph.getVertices().contains(root)) {
            this.forest.addVertex(root);
        }
        this.updateForest(forest.getVertices(), unfinishedEdges);
    }

    public MinimumSpanningForest(Graph<V, E> graph, Forest<V, E> forest, V root) {
        if (forest.getVertexCount() != 0) {
            throw new IllegalArgumentException("Supplied Forest must be empty");
        }
        this.graph = graph;
        this.forest = forest;
        this.weights = Functions.constant((Object)1.0);
        HashSet unfinishedEdges = new HashSet(graph.getEdges());
        if (graph.getVertices().contains(root)) {
            this.forest.addVertex(root);
        }
        this.updateForest(forest.getVertices(), unfinishedEdges);
    }

    public Forest<V, E> getForest() {
        return this.forest;
    }

    protected void updateForest(Collection<V> tv, Collection<E> unfinishedEdges) {
        double minCost = Double.MAX_VALUE;
        Object nextEdge = null;
        Object nextVertex = null;
        Object currentVertex = null;
        for (Object object : unfinishedEdges) {
            if (this.forest.getEdges().contains(object)) continue;
            Pair<V> endpoints = this.graph.getEndpoints(object);
            V first = endpoints.getFirst();
            V second = endpoints.getSecond();
            if (tv.contains(first) && !tv.contains(second) && (Double)this.weights.apply(object) < minCost) {
                minCost = (Double)this.weights.apply(object);
                nextEdge = object;
                currentVertex = first;
                nextVertex = second;
            }
            if (this.graph.getEdgeType(object) != EdgeType.UNDIRECTED || !tv.contains(second) || tv.contains(first) || !((Double)this.weights.apply(object) < minCost)) continue;
            minCost = (Double)this.weights.apply(object);
            nextEdge = object;
            currentVertex = second;
            nextVertex = first;
        }
        if (nextVertex != null && nextEdge != null) {
            unfinishedEdges.remove(nextEdge);
            this.forest.addEdge(nextEdge, currentVertex, nextVertex);
            this.updateForest(this.forest.getVertices(), unfinishedEdges);
        }
        HashSet leftovers = new HashSet(this.graph.getVertices());
        leftovers.removeAll(this.forest.getVertices());
        if (leftovers.size() > 0) {
            Object e = leftovers.iterator().next();
            this.forest.addVertex(e);
            this.updateForest(this.forest.getVertices(), unfinishedEdges);
        }
    }
}

