/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.transform.Lens;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensMagnificationGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseWheelListener {
    private static final Logger log = LoggerFactory.getLogger(LensMagnificationGraphMousePlugin.class);
    protected final float floor;
    protected final float ceiling;
    protected final float delta;
    protected int modifiers;

    public LensMagnificationGraphMousePlugin() {
        this(0);
    }

    public LensMagnificationGraphMousePlugin(float floor, float ceiling, float delta) {
        this(0, floor, ceiling, delta);
    }

    public LensMagnificationGraphMousePlugin(int modifiers) {
        this(modifiers, 0.5f, 4.0f, 0.2f);
    }

    public LensMagnificationGraphMousePlugin(int modifiers, float floor, float ceiling, float delta) {
        this.modifiers = modifiers;
        this.floor = floor;
        this.ceiling = ceiling;
        this.delta = delta;
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return e.getModifiersEx() == this.modifiers;
    }

    private void changeMagnification(Lens lens, float delta) {
        float magnification = lens.getMagnification() + delta;
        magnification = Math.max(this.floor, magnification);
        magnification = Math.min(magnification, this.ceiling);
        lens.setMagnification(magnification);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = e.getModifiersEx() == this.modifiers;
        float delta = this.delta;
        if (accepted) {
            Lens lens;
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            MutableTransformer layoutTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
            int amount = e.getWheelRotation();
            if (amount < 0) {
                delta = -delta;
            }
            Lens lens2 = layoutTransformer instanceof LensTransformer ? ((LensTransformer)layoutTransformer).getLens() : (lens = viewTransformer instanceof LensTransformer ? ((LensTransformer)viewTransformer).getLens() : null);
            if (lens != null && lens.getLensShape().contains(viewTransformer.inverseTransform(e.getPoint()))) {
                this.changeMagnification(lens, -delta);
                vv.repaint();
                e.consume();
            }
        }
    }
}

