/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.main;

public enum VTMarkupItemStatus {
    UNAPPLIED("Unapplied", true, false),
    ADDED("Applied (Added)", false, true),
    REPLACED("Applied (Replaced)", false, true),
    FAILED_APPLY("Apply Failed", false, false),
    DONT_CARE("Don't Care", true, false),
    DONT_KNOW("Don't Know", true, false),
    REJECTED("Rejected", false, false),
    SAME("Destination has same value", false, false),
    CONFLICT("Conflicting item is applied", false, false);

    private final String description;
    private boolean isAppliable;
    private boolean isUnappliable;

    private VTMarkupItemStatus(String description, boolean isAppliable, boolean isUnappliable) {
        this.description = description;
        this.isAppliable = isAppliable;
        this.isUnappliable = isUnappliable;
    }

    public boolean isAppliable() {
        return this.isAppliable;
    }

    public boolean isUnappliable() {
        return this.isUnappliable;
    }

    public boolean isDefault() {
        return this == SAME || this == CONFLICT || this == UNAPPLIED;
    }

    public String getDescription() {
        return this.description;
    }
}

