/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.util.CollectionUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@DebuggerTargetObjectIface(value="Steppable")
public interface TargetSteppable
extends TargetObject {
    public static final String SUPPORTED_STEP_KINDS_ATTRIBUTE_NAME = "_supported_step_kinds";

    @TargetAttributeType(name="_supported_step_kinds", required=true, fixed=true, hidden=true)
    default public TargetStepKindSet getSupportedStepKinds() {
        return this.getTypedAttributeNowByName(SUPPORTED_STEP_KINDS_ATTRIBUTE_NAME, TargetStepKindSet.class, TargetStepKindSet.of());
    }

    public CompletableFuture<Void> step(TargetStepKind var1);

    default public CompletableFuture<Void> step(Map<String, ?> args) {
        return this.step(TargetStepKind.INTO);
    }

    default public CompletableFuture<Void> step() {
        return this.step(TargetStepKind.INTO);
    }

    public static enum TargetStepKind {
        ADVANCE,
        FINISH,
        INTO,
        LINE,
        OVER,
        OVER_LINE,
        SKIP,
        RETURN,
        UNTIL,
        EXTENDED;

    }

    public static interface TargetStepKindSet
    extends Set<TargetStepKind> {
        public static final TargetStepKindSet EMPTY = new EmptyTargetStepKindSet();

        public static TargetStepKindSet of() {
            return EMPTY;
        }

        public static TargetStepKindSet of(TargetStepKind ... kinds) {
            return new ImmutableTargetStepKindSet(kinds);
        }

        public static TargetStepKindSet copyOf(Set<TargetStepKind> set) {
            return new ImmutableTargetStepKindSet(set);
        }

        public static class ImmutableTargetStepKindSet
        extends CollectionUtils.AbstractNSet<TargetStepKind>
        implements TargetStepKindSet {
            public ImmutableTargetStepKindSet(TargetStepKind ... kinds) {
                super(kinds);
            }

            public ImmutableTargetStepKindSet(Set<TargetStepKind> set) {
                super(set);
            }
        }

        public static class EmptyTargetStepKindSet
        extends CollectionUtils.AbstractEmptySet<TargetStepKind>
        implements TargetStepKindSet {
        }
    }
}

