/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class CodeXmlMgr
implements DisassemblerMessageListener {
    private Program program;
    private MessageLog log;

    CodeXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.log = log;
    }

    void write(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing CODE ...");
        writer.startElement("CODE");
        this.exportCode(writer, set, monitor);
        writer.endElement("CODE");
    }

    private void exportCode(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Exporting Code Blocks....");
        InstructionIterator it = null;
        it = set == null ? this.program.getListing().getInstructions(true) : this.program.getListing().getInstructions(set, true);
        if (it.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Instruction inst = it.next();
            Address start = inst.getMinAddress();
            Address end = inst.getMaxAddress();
            while (it.hasNext()) {
                inst = it.next();
                if (!end.isSuccessor(inst.getMinAddress())) {
                    this.exportCodeBlock(writer, start, end);
                    start = inst.getMinAddress();
                }
                end = inst.getMaxAddress();
                if (!monitor.isCancelled()) continue;
            }
            this.exportCodeBlock(writer, start, end);
        }
    }

    private void exportCodeBlock(XmlWriter writer, Address start, Address end) {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("START", XmlProgramUtilities.toString((Address)start));
        attrs.addAttribute("END", XmlProgramUtilities.toString((Address)end));
        writer.startElement("CODE_BLOCK", attrs);
        writer.endElement("CODE_BLOCK");
    }

    void read(XmlPullParser parser, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        AddressSet set = new AddressSet();
        XmlElement element = parser.next();
        element = parser.next();
        while (element.getName().equals("CODE_BLOCK")) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.processCodeBlock(parser, element, monitor, set);
            element = parser.next();
            element = parser.next();
        }
        AddressSet disset = set.intersect((AddressSetView)this.program.getMemory());
        if (!disset.equals((Object)set)) {
            this.log.appendMsg("Disassembly address set changed to " + disset.toString());
        }
        this.disassemble(disset, monitor);
    }

    private void processCodeBlock(XmlPullParser parser, XmlElement element, TaskMonitor monitor, AddressSet set) throws AddressFormatException {
        AddressFactory af = this.program.getAddressFactory();
        String startAddrStr = element.getAttribute("START");
        String endAddrStr = element.getAttribute("END");
        Address start = XmlProgramUtilities.parseAddress((AddressFactory)af, (String)startAddrStr);
        Address end = XmlProgramUtilities.parseAddress((AddressFactory)af, (String)endAddrStr);
        if (start == null || end == null) {
            throw new AddressFormatException("Incompatible Code Block Address Range: [" + startAddrStr + "," + endAddrStr + "]");
        }
        set.addRange(start, end);
    }

    private void disassemble(AddressSet set, TaskMonitor monitor) {
        Disassembler disassembler = Disassembler.getDisassembler((Program)this.program, (TaskMonitor)monitor, (DisassemblerMessageListener)this);
        try {
            Listing listing = this.program.getListing();
            while (!set.isEmpty() && !monitor.isCancelled()) {
                Address start = set.getMinAddress();
                AddressSet disset = disassembler.disassemble(start, (AddressSetView)set);
                if (disset.isEmpty()) {
                    Instruction instr = listing.getInstructionAt(start);
                    if (instr == null) {
                        AddressRange skipRange = (AddressRange)set.iterator().next();
                        this.log.appendMsg("Expected valid Instruction at " + start);
                        this.log.appendMsg("...skipping code range " + skipRange.getMinAddress() + " to " + skipRange.getMaxAddress());
                        set.delete(skipRange);
                        continue;
                    }
                    set.deleteRange(instr.getMinAddress(), instr.getMaxAddress());
                    continue;
                }
                set.delete((AddressSetView)disset);
            }
        }
        catch (Exception e) {
            this.log.appendMsg("Error during disassembly: " + e.getMessage());
        }
    }

    public void disassembleMessageReported(String msg) {
        this.log.appendMsg("Error from disassembler: " + msg);
    }
}

